/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.watcher;

import java.io.File;
import java.io.IOException;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class AdversarialFileWatcher
implements FileWatcher {
    private final FileWatcher fileWatcher;
    private final Adversary adversary;

    public AdversarialFileWatcher(FileWatcher fileWatcher, Adversary adversary) {
        this.fileWatcher = fileWatcher;
        this.adversary = adversary;
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.fileWatcher.close();
    }

    public WatchedResource watch(File file) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.fileWatcher.watch(file);
    }

    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.fileWatcher.addFileWatchEventListener(listener);
    }

    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.fileWatcher.removeFileWatchEventListener(listener);
    }

    public void stopWatching() {
        this.fileWatcher.stopWatching();
    }

    public void startWatching() throws InterruptedException {
        this.adversary.injectFailure(InterruptedException.class);
        this.fileWatcher.startWatching();
    }
}

