/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs.watcher;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.RestartableFileSystemWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

class RestartableFileSystemWatcherTest {
    private FileWatcher delegate = (FileWatcher)Mockito.mock(FileWatcher.class);
    private RestartableFileSystemWatcher watcher = new RestartableFileSystemWatcher(this.delegate);

    RestartableFileSystemWatcherTest() {
    }

    @Test
    void delegateListenersCallToRealWatcher() {
        FileWatchEventListener listener = (FileWatchEventListener)Mockito.mock(FileWatchEventListener.class);
        this.watcher.addFileWatchEventListener(listener);
        ((FileWatcher)Mockito.verify((Object)this.delegate)).addFileWatchEventListener(listener);
        this.watcher.removeFileWatchEventListener(listener);
        ((FileWatcher)Mockito.verify((Object)this.delegate)).removeFileWatchEventListener(listener);
    }

    @Test
    void closeDelegateOnClose() throws IOException {
        this.watcher.close();
        ((FileWatcher)Mockito.verify((Object)this.delegate)).close();
    }

    @Test
    void startStopFileWatchingCycle() throws IOException, InterruptedException {
        File file1 = (File)Mockito.mock(File.class);
        File file2 = (File)Mockito.mock(File.class);
        WatchedResource resource1 = (WatchedResource)Mockito.mock(WatchedResource.class);
        WatchedResource resource2 = (WatchedResource)Mockito.mock(WatchedResource.class);
        this.watcher.watch(file1);
        this.watcher.watch(file2);
        Mockito.when((Object)this.delegate.watch(file1)).thenReturn((Object)resource1);
        Mockito.when((Object)this.delegate.watch(file2)).thenReturn((Object)resource2);
        int invocations = 100;
        for (int i = 0; i < invocations; ++i) {
            this.startStopWatching();
        }
        ((FileWatcher)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)invocations))).watch(file1);
        ((FileWatcher)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)invocations))).watch(file2);
        ((FileWatcher)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)invocations))).startWatching();
        ((FileWatcher)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)invocations))).stopWatching();
        ((WatchedResource)Mockito.verify((Object)resource1, (VerificationMode)Mockito.times((int)invocations))).close();
        ((WatchedResource)Mockito.verify((Object)resource2, (VerificationMode)Mockito.times((int)invocations))).close();
    }

    private void startStopWatching() throws InterruptedException {
        this.watcher.startWatching();
        this.watcher.stopWatching();
    }
}

