/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.TinyLockManager;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.RecordFormat;
import org.neo4j.io.pagecache.stress.RecordStresser;

public class PageCacheStresser {
    private final int maxPages;
    private final int numberOfThreads;
    private final File workingDirectory;

    public PageCacheStresser(int maxPages, int numberOfThreads, File workingDirectory) {
        this.maxPages = maxPages;
        this.numberOfThreads = numberOfThreads;
        this.workingDirectory = workingDirectory;
    }

    public void stress(PageCache pageCache, Condition condition) throws Exception {
        File file = Files.createTempFile(this.workingDirectory.toPath(), "pagecacheundertest", ".bin", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        int cachePageSize = pageCache.pageSize();
        RecordFormat format = new RecordFormat(this.numberOfThreads, cachePageSize);
        int filePageSize = format.getFilePageSize();
        try (PagedFile pagedFile = pageCache.map(file, filePageSize, new OpenOption[0]);){
            List<RecordStresser> recordStressers = this.prepare(condition, pagedFile, format);
            this.verifyResults(format, pagedFile, recordStressers);
            this.execute(recordStressers);
            this.verifyResults(format, pagedFile, recordStressers);
        }
    }

    private List<RecordStresser> prepare(Condition condition, PagedFile pagedFile, RecordFormat format) {
        int maxRecords = Math.multiplyExact(this.maxPages, format.getRecordsPerPage());
        TinyLockManager locks = new TinyLockManager();
        LinkedList<RecordStresser> recordStressers = new LinkedList<RecordStresser>();
        for (int threadId = 0; threadId < this.numberOfThreads; ++threadId) {
            recordStressers.add(new RecordStresser(pagedFile, condition, maxRecords, format, threadId, locks));
        }
        return recordStressers;
    }

    private void execute(List<RecordStresser> recordStressers) throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        List futures = executorService.invokeAll(recordStressers);
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(10L, TimeUnit.SECONDS));
    }

    private void verifyResults(RecordFormat format, PagedFile pagedFile, List<RecordStresser> recordStressers) throws IOException {
        for (RecordStresser stresser : recordStressers) {
            stresser.verifyCounts();
        }
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
                format.verifyCheckSums(cursor);
            }
        }
    }
}

