/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.linear;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.neo4j.io.pagecache.tracing.linear.HEvents;

class LinearHistoryTracer {
    private final AtomicReference<HEvents.HEvent> history = new AtomicReference();
    private final SwitchableBufferedOutputStream bufferOut = new SwitchableBufferedOutputStream();
    private final PrintStream out = new PrintStream(this.bufferOut);

    LinearHistoryTracer() {
    }

    synchronized boolean processHistory(Consumer<HEvents.HEvent> processor) {
        HEvents.HEvent events = this.history.getAndSet(null);
        if (events == null) {
            return false;
        }
        events = HEvents.HEvent.reverse(events);
        while (events != null) {
            processor.accept(events);
            events = events.prev;
        }
        return true;
    }

    <E extends HEvents.HEvent> E add(E event) {
        HEvents.HEvent prev = this.history.getAndSet(event);
        event.prev = prev == null ? HEvents.HEvent.end : prev;
        return event;
    }

    synchronized void printHistory(PrintStream outputStream) {
        this.bufferOut.setOut(outputStream);
        if (!this.processHistory(new HistoryPrinter())) {
            this.out.println("No events recorded.");
        }
        this.out.flush();
    }

    private class HistoryPrinter
    implements Consumer<HEvents.HEvent> {
        private final List<HEvents.HEvent> concurrentIntervals = new LinkedList<HEvents.HEvent>();

        HistoryPrinter() {
        }

        @Override
        public void accept(HEvents.HEvent event) {
            String exceptionLinePrefix = this.exceptionLinePrefix(this.concurrentIntervals.size());
            if (event.getClass() == HEvents.EndHEvent.class) {
                HEvents.EndHEvent endHEvent = (HEvents.EndHEvent)event;
                int idx = this.concurrentIntervals.indexOf(endHEvent.event);
                this.putcs(LinearHistoryTracer.this.out, '|', idx);
                LinearHistoryTracer.this.out.print('-');
                int left = this.concurrentIntervals.size() - idx - 1;
                this.putcs(LinearHistoryTracer.this.out, '|', left);
                LinearHistoryTracer.this.out.print("   ");
                endHEvent.print(LinearHistoryTracer.this.out, exceptionLinePrefix);
                this.concurrentIntervals.remove(idx);
                if (left > 0) {
                    LinearHistoryTracer.this.out.println();
                    this.putcs(LinearHistoryTracer.this.out, '|', idx);
                    this.putcs(LinearHistoryTracer.this.out, '/', left);
                }
            } else if (event instanceof HEvents.IntervalHEvent) {
                this.putcs(LinearHistoryTracer.this.out, '|', this.concurrentIntervals.size());
                LinearHistoryTracer.this.out.print("+   ");
                event.print(LinearHistoryTracer.this.out, exceptionLinePrefix);
                this.concurrentIntervals.add(event);
            } else {
                this.putcs(LinearHistoryTracer.this.out, '|', this.concurrentIntervals.size());
                LinearHistoryTracer.this.out.print(">   ");
                event.print(LinearHistoryTracer.this.out, exceptionLinePrefix);
            }
            LinearHistoryTracer.this.out.println();
        }

        private String exceptionLinePrefix(int size) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append('|');
            }
            sb.append(":  ");
            return sb.toString();
        }

        private void putcs(PrintStream out, char c, int count) {
            for (int i = 0; i < count; ++i) {
                out.print(c);
            }
        }
    }

    private static class SwitchableBufferedOutputStream
    extends BufferedOutputStream {
        SwitchableBufferedOutputStream() {
            super(null);
        }

        public void setOut(OutputStream out) {
            this.out = out;
        }
    }
}

