/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.recording;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.Event;
import org.neo4j.io.pagecache.tracing.recording.RecordingTracer;

public class RecordingPageCacheTracer
extends RecordingTracer
implements PageCacheTracer {
    private AtomicLong pins = new AtomicLong();
    private AtomicLong faults = new AtomicLong();
    private AtomicLong evictions = new AtomicLong();

    public RecordingPageCacheTracer() {
        super(Evict.class);
    }

    public void mappedFile(File file) {
    }

    public void unmappedFile(File file) {
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return new EvictionRunEvent(){

            public EvictionEvent beginEviction() {
                return new RecordingEvictionEvent();
            }

            public void close() {
            }
        };
    }

    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return MajorFlushEvent.NULL;
    }

    public MajorFlushEvent beginCacheFlush() {
        return MajorFlushEvent.NULL;
    }

    public long faults() {
        return this.faults.get();
    }

    public long pins() {
        return this.pins.get();
    }

    public long evictions() {
        return 0L;
    }

    public long unpins() {
        return 0L;
    }

    public long hits() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long filesMapped() {
        return 0L;
    }

    public long filesUnmapped() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public double hitRatio() {
        return 0.0;
    }

    public double usageRatio() {
        return 0.0;
    }

    public void pins(long pins) {
        this.pins.getAndAdd(pins);
    }

    public void unpins(long unpins) {
    }

    public void hits(long hits) {
    }

    public void faults(long faults) {
        this.faults.getAndAdd(faults);
    }

    public void bytesRead(long bytesRead) {
    }

    public void evictions(long evictions) {
        this.evictions.getAndAdd(evictions);
    }

    public void evictionExceptions(long evictionExceptions) {
    }

    public void bytesWritten(long bytesWritten) {
    }

    public void flushes(long flushes) {
    }

    public void maxPages(long maxPages) {
    }

    private void evicted(long filePageId, PageSwapper swapper) {
        this.record(new Evict(swapper, filePageId));
    }

    private class RecordingEvictionEvent
    implements EvictionEvent {
        private long filePageId;
        private PageSwapper swapper;

        private RecordingEvictionEvent() {
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return FlushEventOpportunity.NULL;
        }

        public void threwException(IOException exception) {
        }

        public void setCachePageId(long cachePageId) {
        }

        public void close() {
            RecordingPageCacheTracer.this.evicted(this.filePageId, this.swapper);
        }
    }

    public static class Evict
    extends Event {
        private Evict(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }
}

