/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.proc;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class ProcessUtil {
    private ProcessUtil() {
    }

    public static Path getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        return Paths.get(javaHome, "bin", "java");
    }

    public static List<String> getJavaExecutableArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMxBean.getInputArguments();
    }

    public static List<String> getClassPathList() {
        return Arrays.asList(ProcessUtil.getClassPath().split(File.pathSeparator));
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }
}

