/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class ByteBufferFactory
implements AutoCloseable {
    private final Allocator globalAllocator;
    private final int threadLocalBufferSize;
    private final ThreadLocal<ThreadLocalByteBuffer> threadLocalBuffers = ThreadLocal.withInitial(() -> new ThreadLocalByteBuffer());
    private final Supplier<Allocator> allocatorFactory;
    private static final Allocator HEAP_ALLOCATOR = new Allocator(){

        @Override
        public ScopedBuffer allocate(int bufferSize, MemoryTracker memoryTracker) {
            return new HeapScopedBuffer(bufferSize, memoryTracker);
        }

        @Override
        public void close() {
        }
    };

    public ByteBufferFactory(Supplier<Allocator> allocatorFactory, int threadLocalBufferSize) {
        this.allocatorFactory = allocatorFactory;
        this.globalAllocator = allocatorFactory.get();
        this.threadLocalBufferSize = threadLocalBufferSize;
    }

    public Allocator globalAllocator() {
        return this.globalAllocator;
    }

    public Allocator newLocalAllocator() {
        return this.allocatorFactory.get();
    }

    public ByteBuffer acquireThreadLocalBuffer(MemoryTracker memoryTracker) {
        return this.threadLocalBuffers.get().acquire(memoryTracker);
    }

    public void releaseThreadLocalBuffer() {
        ThreadLocalByteBuffer managedByteBuffer = this.threadLocalBuffers.get();
        Preconditions.checkState((managedByteBuffer != null ? 1 : 0) != 0, (String)"Buffer doesn't exist");
        managedByteBuffer.release();
    }

    public int bufferSize() {
        return this.threadLocalBufferSize;
    }

    @Override
    public void close() {
        this.globalAllocator.close();
    }

    public static ByteBufferFactory heapBufferFactory(int sharedBuffersSize) {
        return new ByteBufferFactory(() -> HEAP_ALLOCATOR, sharedBuffersSize);
    }

    private class ThreadLocalByteBuffer {
        private boolean acquired;
        private ScopedBuffer scopedBuffer;

        private ThreadLocalByteBuffer() {
        }

        ByteBuffer acquire(MemoryTracker memoryTracker) {
            Preconditions.checkState((!this.acquired ? 1 : 0) != 0, (String)"Already acquired");
            this.acquired = true;
            if (this.scopedBuffer == null) {
                this.scopedBuffer = ByteBufferFactory.this.globalAllocator.allocate(ByteBufferFactory.this.threadLocalBufferSize, memoryTracker);
            } else {
                this.scopedBuffer.getBuffer().clear();
            }
            return this.scopedBuffer.getBuffer();
        }

        void release() {
            Preconditions.checkState((boolean)this.acquired, (String)"Not acquired");
            this.acquired = false;
        }
    }

    public static interface Allocator
    extends AutoCloseable {
        public ScopedBuffer allocate(int var1, MemoryTracker var2);

        @Override
        public void close();
    }
}

