/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public final class SwapperSet {
    public static final int FREE_CANDIDATES_THRESHOLD = 16384;
    private static final SwapperMapping SENTINEL = new SwapperMapping(0, null);
    private static final int MAX_SWAPPER_ID = 0x1FFFFF;
    private volatile SwapperMapping[] swapperMappings = new SwapperMapping[]{SENTINEL};
    private final LinkedList<Integer> free = new LinkedList();
    private final MutableIntSet postponedIds = new IntHashSet();
    private final Lock sweepCandidatesLock = new ReentrantLock();

    SwapperMapping getAllocation(int id) {
        Preconditions.requirePositive((int)id);
        return this.swapperMappings[id];
    }

    public synchronized int allocate(PageSwapper swapper) {
        SwapperMapping[] swapperMappings = this.swapperMappings;
        Integer freeId = this.free.pollFirst();
        if (freeId != null) {
            int id = freeId;
            swapperMappings[id] = new SwapperMapping(id, swapper);
            this.swapperMappings = swapperMappings;
            return id;
        }
        int id = swapperMappings.length;
        if (id + 1 > 0x1FFFFF) {
            throw new IllegalStateException("All swapper ids are allocated: 2097151");
        }
        swapperMappings = Arrays.copyOf(swapperMappings, id + 1);
        swapperMappings[id] = new SwapperMapping(id, swapper);
        this.swapperMappings = swapperMappings;
        return id;
    }

    synchronized void free(int id) {
        Preconditions.requirePositive((int)id);
        SwapperMapping[] swapperMappings = this.swapperMappings;
        SwapperMapping current = swapperMappings[id];
        if (current == null) {
            throw new IllegalStateException("PageSwapper allocation id " + id + " is currently not allocated. Likely a double free bug.");
        }
        swapperMappings[id] = null;
        this.swapperMappings = swapperMappings;
        this.free.add(id);
    }

    public synchronized void postponedFree(int swapperId) {
        this.postponedIds.add(swapperId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sweep(Consumer<IntSet> evictAllLoadedPagesCallback) {
        if (this.skipSweep()) {
            return;
        }
        this.sweepCandidatesLock.lock();
        try {
            if (this.skipSweep()) {
                return;
            }
            ImmutableIntSet candidates = this.sweepCandidates();
            evictAllLoadedPagesCallback.accept((IntSet)candidates);
            SwapperSet swapperSet = this;
            synchronized (swapperSet) {
                candidates.forEach((IntProcedure & Serializable)id -> {
                    this.postponedIds.remove(id);
                    this.free(id);
                });
            }
        }
        finally {
            this.sweepCandidatesLock.unlock();
        }
    }

    @VisibleForTesting
    synchronized boolean skipSweep() {
        return this.postponedIds.size() < 16384;
    }

    private synchronized ImmutableIntSet sweepCandidates() {
        return this.postponedIds.toImmutable();
    }

    static final class SwapperMapping {
        public final int id;
        public final PageSwapper swapper;

        private SwapperMapping(int id, PageSwapper swapper) {
            this.id = id;
            this.swapper = swapper;
        }
    }
}

