/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

public enum PermissionState {
    NOT_GRANTED,
    EXPLICIT_GRANT,
    EXPLICIT_DENY;


    public PermissionState combine(PermissionState p) {
        int order = this.compareTo(p);
        if (order <= 0) {
            return p;
        }
        return this;
    }

    public PermissionState restrict(PermissionState restricting) {
        if (this.allowsAccess() && restricting.allowsAccess()) {
            return EXPLICIT_GRANT;
        }
        if (this == EXPLICIT_DENY || restricting == EXPLICIT_DENY) {
            return EXPLICIT_DENY;
        }
        return NOT_GRANTED;
    }

    public boolean allowsAccess() {
        return this == EXPLICIT_GRANT;
    }

    public static PermissionState fromAllowList(boolean permitted) {
        if (permitted) {
            return EXPLICIT_GRANT;
        }
        return NOT_GRANTED;
    }

    public static PermissionState fromDenyList(boolean permitted) {
        if (permitted) {
            return NOT_GRANTED;
        }
        return EXPLICIT_DENY;
    }
}

