/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadCounter = new AtomicInteger(1);
    private String threadNamePrefix;
    private final int priority;

    public NamedThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, 5);
    }

    public NamedThreadFactory(String threadNamePrefix, int priority) {
        this.threadNamePrefix = threadNamePrefix;
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        int id = this.threadCounter.getAndIncrement();
        Thread result = new Thread(this.group, runnable, this.threadNamePrefix + "-" + id);
        result.setDaemon(false);
        result.setPriority(this.priority);
        return result;
    }
}

