/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;

public class PropertyPhysicalToLogicalConverter {
    private final PropertyStore propertyStore;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public Iterable<NodePropertyUpdate> apply(PropertyRecord before, long[] labelsBefore, PropertyRecord after, long[] labelsAfter) {
        assert (before.getNodeId() == after.getNodeId()) : "Node ids differ between before(" + before.getNodeId() + ") and after(" + after.getNodeId() + ")";
        long nodeId = before.getNodeId();
        Map<Integer, PropertyBlock> beforeMap = this.mapBlocks(before);
        Map<Integer, PropertyBlock> afterMap = this.mapBlocks(after);
        Set allKeys = this.union(beforeMap.keySet(), afterMap.keySet());
        ArrayList<NodePropertyUpdate> result = new ArrayList<NodePropertyUpdate>();
        Iterator i$ = allKeys.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            PropertyBlock beforeBlock = beforeMap.get(key);
            PropertyBlock afterBlock = afterMap.get(key);
            NodePropertyUpdate update = null;
            if (beforeBlock != null && afterBlock != null) {
                if (!beforeBlock.hasSameContentsAs(afterBlock)) {
                    Object beforeVal = this.valueOf(beforeBlock);
                    Object afterVal = this.valueOf(afterBlock);
                    update = NodePropertyUpdate.change(nodeId, key, beforeVal, labelsBefore, afterVal, labelsAfter);
                }
            } else if (afterBlock != null) {
                update = NodePropertyUpdate.add(nodeId, key, this.valueOf(afterBlock), labelsAfter);
            } else if (beforeBlock != null) {
                update = NodePropertyUpdate.remove(nodeId, key, this.valueOf(beforeBlock), labelsBefore);
            } else {
                throw new IllegalStateException("Weird, an update with no property value for before or after");
            }
            if (update == null) continue;
            result.add(update);
        }
        return result;
    }

    private <T> Set<T> union(Set<T> ... sets) {
        HashSet<T> union = new HashSet<T>();
        for (Set<T> set : sets) {
            union.addAll(set);
        }
        return union;
    }

    private Map<Integer, PropertyBlock> mapBlocks(PropertyRecord before) {
        HashMap<Integer, PropertyBlock> map = new HashMap<Integer, PropertyBlock>();
        for (PropertyBlock block : before.getPropertyBlocks()) {
            map.put(block.getKeyIndexId(), block);
        }
        return map;
    }

    private Object valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().getValue(block, this.propertyStore);
    }
}

