/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class BufferedFileChannel
extends FileChannel {
    private final FileChannel source;
    private final byte[] intermediaryBuffer = new byte[8192];
    private int intermediaryBufferSize;
    private int intermediaryBufferPosition;

    public BufferedFileChannel(FileChannel source) throws IOException {
        this.source = source;
        this.fillUpIntermediaryBuffer();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = 0;
        while (read < dst.limit() && ((read += this.readAsMuchAsPossibleFromIntermediaryBuffer(dst)) >= dst.limit() || this.fillUpIntermediaryBuffer() != -1)) {
        }
        return read == 0 && dst.limit() > 0 ? -1 : read;
    }

    private int readAsMuchAsPossibleFromIntermediaryBuffer(ByteBuffer dst) {
        int howMuchToRead = Math.min(dst.remaining(), this.remainingInIntermediaryBuffer());
        dst.put(this.intermediaryBuffer, this.intermediaryBufferPosition, howMuchToRead);
        this.intermediaryBufferPosition += howMuchToRead;
        return howMuchToRead;
    }

    private int remainingInIntermediaryBuffer() {
        return this.intermediaryBufferSize - this.intermediaryBufferPosition;
    }

    private int fillUpIntermediaryBuffer() throws IOException {
        int result = this.source.read(ByteBuffer.wrap(this.intermediaryBuffer));
        this.intermediaryBufferPosition = 0;
        this.intermediaryBufferSize = result == -1 ? 0 : result;
        return result;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.source.position() - (long)this.intermediaryBufferSize + (long)this.intermediaryBufferPosition;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        long bufferEndPosition = this.source.position();
        long bufferStartPosition = bufferEndPosition - (long)this.intermediaryBufferSize;
        if (newPosition >= bufferStartPosition && newPosition <= bufferEndPosition) {
            long diff = newPosition - this.position();
            this.intermediaryBufferPosition = (int)((long)this.intermediaryBufferPosition + diff);
        } else {
            this.source.position(newPosition);
            this.fillUpIntermediaryBuffer();
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.source.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.source.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.source.force(metaData);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.source.close();
    }

    public FileChannel getSource() {
        return this.source;
    }
}

