/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.TreeSet;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;

public class DumpLogicalLog {
    private final FileSystemAbstraction fileSystem;
    private static final Printer SYSTEM_OUT_PRINTER = new Printer(){

        @Override
        public PrintStream getFor(String file) {
            return System.out;
        }

        @Override
        public void close() {
        }
    };

    public DumpLogicalLog(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    public int dump(String filenameOrDirectory, PrintStream out, TimeZone timeZone) throws IOException {
        int logsFound = 0;
        for (String fileName : DumpLogicalLog.filenamesOf(filenameOrDirectory, this.getLogPrefix())) {
            long prevLastCommittedTx;
            long logVersion;
            ++logsFound;
            out.println("=== " + fileName + " ===");
            FileChannel fileChannel = this.fileSystem.open(new File(fileName), "r");
            ByteBuffer buffer = ByteBuffer.allocateDirect(713);
            try {
                long[] header = LogIoUtils.readLogHeader(buffer, fileChannel, true);
                logVersion = header[0];
                prevLastCommittedTx = header[1];
            }
            catch (IOException ex) {
                out.println("Unable to read timestamp information, no records in logical log.");
                out.println(ex.getMessage());
                fileChannel.close();
                throw ex;
            }
            out.println("Logical log version: " + logVersion + " with prev committed tx[" + prevLastCommittedTx + "]");
            XaCommandFactory cf = this.instantiateCommandFactory();
            while (this.readAndPrintEntry(fileChannel, buffer, cf, out, timeZone)) {
            }
            fileChannel.close();
        }
        return logsFound;
    }

    protected static boolean isAGraphDatabaseDirectory(String fileName) {
        File file = new File(fileName);
        return file.isDirectory() && new File(file, "neostore").exists();
    }

    protected boolean readAndPrintEntry(FileChannel fileChannel, ByteBuffer buffer, XaCommandFactory cf, PrintStream out, TimeZone timeZone) throws IOException {
        LogEntry entry = LogIoUtils.readEntry(buffer, fileChannel, cf);
        if (entry != null) {
            out.println(entry.toString(timeZone));
            return true;
        }
        return false;
    }

    protected XaCommandFactory instantiateCommandFactory() {
        return new CommandFactory();
    }

    protected String getLogPrefix() {
        return "nioneo_logical.log";
    }

    public static void main(String[] args) throws IOException {
        Args arguments = new Args(args);
        TimeZone timeZone = DumpLogicalLog.parseTimeZoneConfig(arguments);
        try (Printer printer = DumpLogicalLog.getPrinter(arguments);){
            for (String fileAsString : arguments.orphans()) {
                new DumpLogicalLog(new DefaultFileSystemAbstraction()).dump(fileAsString, printer.getFor(fileAsString), timeZone);
            }
        }
    }

    public static Printer getPrinter(Args args) {
        boolean toFile = args.getBoolean("tofile", false, true);
        return toFile ? new FilePrinter() : SYSTEM_OUT_PRINTER;
    }

    public static TimeZone parseTimeZoneConfig(Args arguments) {
        return TimeZone.getTimeZone(arguments.get("timezone", Format.DEFAULT_TIME_ZONE.getID()));
    }

    protected static String[] filenamesOf(String filenameOrDirectory, final String prefix) {
        File file = new File(filenameOrDirectory);
        if (file.isDirectory()) {
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(prefix) && !name.contains("active");
                }
            });
            TreeSet<? super String> result = new TreeSet<String>(DumpLogicalLog.sequentialComparator());
            for (int i = 0; i < files.length; ++i) {
                result.add(files[i].getPath());
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[]{filenameOrDirectory};
    }

    private static Comparator<? super String> sequentialComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return this.versionOf(o1).compareTo(this.versionOf(o2));
            }

            private Integer versionOf(String string) {
                String toFind = ".v";
                int index = string.indexOf(toFind);
                if (index == -1) {
                    return Integer.MAX_VALUE;
                }
                return Integer.valueOf(string.substring(index + toFind.length()));
            }
        };
    }

    public static class CommandFactory
    extends XaCommandFactory {
        @Override
        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, null, byteChannel, buffer);
        }
    }

    private static class FilePrinter
    implements Printer {
        private File directory;
        private PrintStream out;

        private FilePrinter() {
        }

        @Override
        public PrintStream getFor(String file) throws FileNotFoundException {
            File dir;
            File absoluteFile = new File(file).getAbsoluteFile();
            File file2 = dir = absoluteFile.isDirectory() ? absoluteFile : absoluteFile.getParentFile();
            if (!dir.equals(this.directory)) {
                this.safeClose();
                File dumpFile = new File(dir, "dump-logical-log.txt");
                System.out.println("Redirecting the output to " + dumpFile.getPath());
                this.out = new PrintStream(dumpFile);
                this.directory = dir;
            }
            return this.out;
        }

        private void safeClose() {
            if (this.out != null) {
                this.out.close();
            }
        }

        @Override
        public void close() {
            this.safeClose();
        }
    }

    public static interface Printer
    extends AutoCloseable {
        public PrintStream getFor(String var1) throws FileNotFoundException;

        @Override
        public void close();
    }
}

