/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.logging.LogMarker;

public abstract class StringLogger {
    public static final String DEFAULT_NAME = "messages.log";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final StringLogger SYSTEM = StringLogger.instantiateStringLoggerForPrintStream(System.out);
    public static final StringLogger SYSTEM_ERR = StringLogger.instantiateStringLoggerForPrintStream(System.err);
    private static final int DEFAULT_THRESHOLD_FOR_ROTATION = 0x6400000;
    private static final int NUMBER_OF_OLD_LOGS_TO_KEEP = 2;
    public static final StringLogger DEV_NULL = new StringLogger(){

        @Override
        public void logMessage(String msg, boolean flush) {
        }

        @Override
        public void logMessage(String msg, LogMarker marker) {
        }

        @Override
        public void logMessage(String msg, Throwable cause, boolean flush) {
        }

        @Override
        public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
        }

        @Override
        protected void logLine(String line) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void addRotationListener(Runnable listener) {
        }
    };

    private static ActualStringLogger instantiateStringLoggerForPrintStream(PrintStream stream) {
        PrintWriter writer;
        try {
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)stream, DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new ActualStringLogger(writer){

            @Override
            public void close() {
            }
        };
    }

    public static StringLogger logger(File logfile) {
        try {
            return new ActualStringLogger(new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logfile, true), DEFAULT_ENCODING)));
        }
        catch (IOException cause) {
            throw new RuntimeException("Could not create log file: " + logfile, cause);
        }
    }

    public static StringLogger loggerDirectory(FileSystemAbstraction fileSystem, File logDirectory) {
        return StringLogger.loggerDirectory(fileSystem, logDirectory, 0x6400000);
    }

    public static StringLogger loggerDirectory(FileSystemAbstraction fileSystem, File logDirectory, int rotationThreshold) {
        return new ActualStringLogger(fileSystem, new File(logDirectory, DEFAULT_NAME).getPath(), rotationThreshold);
    }

    public static StringLogger wrap(Writer writer) {
        return new ActualStringLogger(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public static StringLogger wrap(final StringBuffer target) {
        return new ActualStringLogger(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                target.append(cbuf, off, len);
            }

            @Override
            public void write(int c) throws IOException {
                target.appendCodePoint(c);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                target.append(cbuf);
            }

            @Override
            public void write(String str) throws IOException {
                target.append(str);
            }

            @Override
            public void write(String str, int off, int len) throws IOException {
                target.append(str, off, len);
            }

            @Override
            public Writer append(char c) throws IOException {
                target.append(c);
                return this;
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                target.append(csq);
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                target.append(csq, start, end);
                return this;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }));
    }

    public static StringLogger tee(final StringLogger logger1, final StringLogger logger2) {
        return new StringLogger(){

            @Override
            public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
                logger1.logLongMessage(msg, source, flush);
                logger2.logLongMessage(msg, source, flush);
            }

            @Override
            public void logMessage(String msg, boolean flush) {
                logger1.logMessage(msg, flush);
                logger2.logMessage(msg, flush);
            }

            @Override
            public void logMessage(String msg, LogMarker marker) {
                logger1.logMessage(msg, marker);
                logger2.logMessage(msg, marker);
            }

            @Override
            public void logMessage(String msg, Throwable cause, boolean flush) {
                logger1.logMessage(msg, cause, flush);
                logger2.logMessage(msg, cause, flush);
            }

            @Override
            public void addRotationListener(Runnable listener) {
                logger1.addRotationListener(listener);
                logger2.addRotationListener(listener);
            }

            @Override
            public void flush() {
                logger1.flush();
                logger2.flush();
            }

            @Override
            public void close() {
                logger1.close();
                logger2.close();
            }

            @Override
            protected void logLine(String line) {
                logger1.logLine(line);
                logger2.logLine(line);
            }
        };
    }

    public static StringLogger lazyLogger(final File logFile) {
        return new StringLogger(){
            StringLogger logger = null;

            @Override
            public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
                this.createLogger();
                this.logger.logLongMessage(msg, source, flush);
            }

            @Override
            public void logMessage(String msg, boolean flush) {
                this.createLogger();
                this.logger.logMessage(msg, flush);
            }

            @Override
            public void logMessage(String msg, LogMarker marker) {
                this.createLogger();
                this.logger.logMessage(msg, marker);
            }

            @Override
            public void logMessage(String msg, Throwable cause, boolean flush) {
                this.createLogger();
                this.logger.logMessage(msg, cause, flush);
            }

            @Override
            public void addRotationListener(Runnable listener) {
                this.createLogger();
                this.logger.addRotationListener(listener);
            }

            @Override
            public void flush() {
                this.createLogger();
                this.logger.flush();
            }

            @Override
            public void close() {
                if (this.logger != null) {
                    this.logger.close();
                }
            }

            @Override
            protected void logLine(String line) {
                this.createLogger();
                this.logger.logLine(line);
            }

            private synchronized void createLogger() {
                if (this.logger == null) {
                    this.logger = 4.logger(logFile);
                }
            }
        };
    }

    public void logMessage(String msg) {
        this.logMessage(msg, false);
    }

    public void logMessage(String msg, Throwable cause) {
        this.logMessage(msg, cause, false);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logMessage(msg);
        }
    }

    public void debug(String msg, Throwable cause) {
        if (this.isDebugEnabled()) {
            this.logMessage(msg, cause);
        }
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void info(String msg) {
        this.logMessage(msg);
    }

    public void info(String msg, Throwable cause) {
        this.logMessage(msg, cause);
    }

    public void warn(String msg) {
        this.logMessage(msg);
    }

    public void warn(String msg, Throwable throwable) {
        this.logMessage(msg, throwable);
    }

    public void error(String msg) {
        this.logMessage(msg);
    }

    public void error(String msg, Throwable throwable) {
        this.logMessage(msg, throwable);
    }

    public void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, Iterable<String> source, boolean flush) {
        this.logLongMessage(msg, source.iterator(), flush);
    }

    public void logLongMessage(String msg, Iterator<String> source) {
        this.logLongMessage(msg, source, false);
    }

    public void logLongMessage(String msg, final Iterator<String> source, boolean flush) {
        this.logLongMessage(msg, new Visitor<LineLogger, RuntimeException>(){

            @Override
            public boolean visit(LineLogger logger) {
                for (String line : IteratorUtil.loop(source)) {
                    logger.logLine(line);
                }
                return true;
            }
        }, flush);
    }

    public abstract void logLongMessage(String var1, Visitor<LineLogger, RuntimeException> var2, boolean var3);

    public abstract void logMessage(String var1, boolean var2);

    public abstract void logMessage(String var1, LogMarker var2);

    public abstract void logMessage(String var1, Throwable var2, boolean var3);

    public abstract void addRotationListener(Runnable var1);

    public abstract void flush();

    public abstract void close();

    protected abstract void logLine(String var1);

    protected static final class LineLoggerImpl
    implements LineLogger {
        private final StringLogger target;

        public LineLoggerImpl(StringLogger target) {
            this.target = target;
        }

        @Override
        public void logLine(String line) {
            this.target.logLine(line);
        }
    }

    private static class ActualStringLogger
    extends StringLogger {
        private static final String encoding = "UTF-8";
        private PrintWriter out;
        private final Integer rotationThreshold;
        private final File file;
        private final List<Runnable> onRotation = new CopyOnWriteArrayList<Runnable>();
        private final FileSystemAbstraction fileSystem;
        private volatile boolean doingRotation = false;

        private ActualStringLogger(FileSystemAbstraction fileSystem, String filename, int rotationThreshold) {
            this.fileSystem = fileSystem;
            this.rotationThreshold = rotationThreshold;
            try {
                this.file = new File(filename);
                if (this.file.getParentFile() != null) {
                    fileSystem.mkdirs(this.file.getParentFile());
                }
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ActualStringLogger(PrintWriter writer) {
            this.out = writer;
            this.rotationThreshold = null;
            this.file = null;
            this.fileSystem = null;
        }

        @Override
        public void addRotationListener(Runnable trigger) {
            this.onRotation.add(trigger);
        }

        private void instantiateWriter() throws IOException {
            this.out = new PrintWriter(new OutputStreamWriter(this.fileSystem.openAsOutputStream(this.file, true), "UTF-8"));
            for (Runnable trigger : this.onRotation) {
                trigger.run();
            }
        }

        @Override
        public synchronized void logMessage(String msg, boolean flush) {
            this.out.println(this.time() + " INFO  [org.neo4j]: " + msg);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        public void logMessage(String msg, LogMarker marker) {
            this.logMessage(msg);
        }

        private String time() {
            return Format.date();
        }

        @Override
        public synchronized void logMessage(String msg, Throwable cause, boolean flush) {
            this.out.println(this.time() + " ERROR [org.neo4j]: " + msg + " " + cause.getMessage());
            cause.printStackTrace(this.out);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        public synchronized void logLongMessage(String msg, Visitor<LineLogger, RuntimeException> source, boolean flush) {
            this.out.println(this.time() + " INFO  [org.neo4j]: " + msg);
            source.visit(new LineLoggerImpl(this));
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        @Override
        protected void logLine(String line) {
            this.out.println("    " + line);
        }

        private void checkRotation() {
            if (this.rotationThreshold != null && this.fileSystem.getFileSize(this.file) > (long)this.rotationThreshold.intValue() && !this.doingRotation) {
                this.doRotation();
            }
        }

        private void doRotation() {
            this.doingRotation = true;
            this.out.close();
            this.moveAwayFile();
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.doingRotation = false;
            }
        }

        private void moveAwayFile() {
            File oldLogFile = new File(this.file.getParentFile(), this.file.getName() + "." + 2);
            if (this.fileSystem.fileExists(oldLogFile)) {
                this.fileSystem.deleteFile(oldLogFile);
            }
            for (int i = 1; i >= 0; --i) {
                oldLogFile = new File(this.file.getParentFile(), this.file.getName() + (i == 0 ? "" : "." + i));
                if (!this.fileSystem.fileExists(oldLogFile)) continue;
                try {
                    this.fileSystem.renameFile(oldLogFile, new File(this.file.getParentFile(), this.file.getName() + "." + (i + 1)));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }

        public String toString() {
            return "StringLogger[" + this.file + "]";
        }
    }

    public static interface LineLogger {
        public void logLine(String var1);
    }
}

