/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;

class PreorderBreadthFirstSelector
implements BranchSelector {
    private final Queue<TraversalBranch> queue = new LinkedList<TraversalBranch>();
    private TraversalBranch current;
    private final PathExpander expander;

    public PreorderBreadthFirstSelector(TraversalBranch startSource, PathExpander expander) {
        this.current = startSource;
        this.expander = expander;
    }

    @Override
    public TraversalBranch next(TraversalContext metadata) {
        TraversalBranch result = null;
        while (result == null) {
            TraversalBranch next = this.current.next(this.expander, metadata);
            if (next != null) {
                this.queue.add(next);
                result = next;
                continue;
            }
            this.current = this.queue.poll();
            if (this.current != null) continue;
            return null;
        }
        return result;
    }
}

