/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.register.Register;

public interface IndexPopulator {
    public void create() throws IOException;

    public void drop() throws IOException;

    public void add(long var1, Object var3) throws IndexEntryConflictException, IOException, IndexCapacityExceededException;

    @Deprecated
    public void verifyDeferredConstraints(PropertyAccessor var1) throws IndexEntryConflictException, IOException;

    public IndexUpdater newPopulatingUpdater(PropertyAccessor var1) throws IOException;

    public void close(boolean var1) throws IOException, IndexCapacityExceededException;

    public void markAsFailed(String var1) throws IOException;

    public long sampleResult(Register.DoubleLong.Out var1);

    public static class Adapter
    implements IndexPopulator {
        @Override
        public void create() throws IOException {
        }

        @Override
        public void drop() throws IOException {
        }

        @Override
        public void add(long nodeId, Object propertyValue) throws IndexEntryConflictException, IOException {
        }

        @Override
        public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        }

        @Override
        public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void close(boolean populationCompletedSuccessfully) throws IOException {
        }

        @Override
        public void markAsFailed(String failure) {
        }

        @Override
        public long sampleResult(Register.DoubleLong.Out result) {
            result.write(0L, 0L);
            return 0L;
        }
    }
}

