/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.RecordState;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsRecordState
implements CountsAccessor,
RecordState,
CountsAccessor.Updater,
CountsAccessor.IndexStatsUpdater {
    private static final boolean COMPUTE_DOUBLE_SIDED_RELATIONSHIP_COUNTS = false;
    private static final long DEFAULT_FIRST_VALUE = 0L;
    private static final long DEFAULT_SECOND_VALUE = 0L;
    private final Map<CountsKey, Register.DoubleLongRegister> counts = new HashMap<CountsKey, Register.DoubleLongRegister>();

    @Override
    public Register.DoubleLongRegister nodeCount(int labelId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.nodeKey(labelId)).copyTo((Register.DoubleLong.Out)target);
        return target;
    }

    @Override
    public void incrementNodeCount(int labelId, long delta) {
        this.counts(CountsKeyFactory.nodeKey(labelId)).increment(0L, delta);
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(int startLabelId, int typeId, int endLabelId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId)).copyTo((Register.DoubleLong.Out)target);
        return target;
    }

    @Override
    public Register.DoubleLongRegister indexSample(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId)).copyTo((Register.DoubleLong.Out)target);
        return target;
    }

    @Override
    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        if (delta != 0L) {
            this.counts(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId)).increment(0L, delta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        this.counts(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId)).copyTo((Register.DoubleLong.Out)target);
        return target;
    }

    @Override
    public void replaceIndexUpdateAndSize(int labelId, int propertyKeyId, long updates, long size) {
        this.counts(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId)).write(updates, size);
    }

    @Override
    public void incrementIndexUpdates(int labelId, int propertyKeyId, long delta) {
        this.counts(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId)).increment(delta, 0L);
    }

    @Override
    public void replaceIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        this.counts(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId)).write(unique, size);
    }

    @Override
    public void close() {
    }

    @Override
    public void accept(CountsVisitor visitor) {
        for (Map.Entry<CountsKey, Register.DoubleLongRegister> entry : this.counts.entrySet()) {
            Register.DoubleLongRegister register = entry.getValue();
            entry.getKey().accept(visitor, register.readFirst(), register.readSecond());
        }
    }

    @Override
    public void extractCommands(Collection<Command> target) {
        this.accept(new CommandCollector(target));
    }

    public List<Difference> verify(CountsVisitor.Visitable visitable) {
        Verifier verifier = new Verifier(this.counts);
        visitable.accept(verifier);
        return verifier.differences();
    }

    @Override
    public boolean hasChanges() {
        return !this.counts.isEmpty();
    }

    public void initialize() {
        if (!this.counts.isEmpty()) {
            this.counts.clear();
        }
    }

    public void addNode(long[] labels) {
        this.incrementNodeCount(-1, 1L);
        for (long label : labels) {
            this.incrementNodeCount((int)label, 1L);
        }
    }

    public void addRelationship(long[] startLabels, int type, long[] endLabels) {
        this.incrementRelationshipCount(-1, -1, -1, 1L);
        this.incrementRelationshipCount(-1, type, -1, 1L);
        for (long startLabelId : startLabels) {
            this.incrementRelationshipCount((int)startLabelId, -1, -1, 1L);
            this.incrementRelationshipCount((int)startLabelId, type, -1, 1L);
        }
        for (long endLabelId : endLabels) {
            this.incrementRelationshipCount(-1, -1, (int)endLabelId, 1L);
            this.incrementRelationshipCount(-1, type, (int)endLabelId, 1L);
        }
    }

    private Register.DoubleLongRegister counts(CountsKey key) {
        Register.DoubleLongRegister count = this.counts.get(key);
        if (count == null) {
            count = Registers.newDoubleLongRegister((long)0L, (long)0L);
            this.counts.put(key, count);
        }
        return count;
    }

    private static class Verifier
    implements CountsVisitor {
        private final Map<CountsKey, Register.DoubleLongRegister> counts;
        private final List<Difference> differences = new ArrayList<Difference>();

        Verifier(Map<CountsKey, Register.DoubleLongRegister> counts) {
            this.counts = new HashMap<CountsKey, Register.DoubleLongRegister>(counts);
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.verify(CountsKeyFactory.nodeKey(labelId), 0L, count);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.verify(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), 0L, count);
        }

        @Override
        public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
            this.verify(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), updates, size);
        }

        @Override
        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
            this.verify(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), unique, size);
        }

        private void verify(CountsKey key, long actualFirst, long actualSecond) {
            Register.DoubleLongRegister expected = this.counts.remove(key);
            if (expected == null) {
                if (actualFirst != 0L || actualSecond != 0L) {
                    this.differences.add(new Difference(key, 0L, 0L, actualFirst, actualSecond));
                }
            } else {
                long expectedFirst = expected.readFirst();
                long expectedSecond = expected.readSecond();
                if (expectedFirst != actualFirst || expectedSecond != actualSecond) {
                    this.differences.add(new Difference(key, expectedFirst, expectedSecond, actualFirst, actualSecond));
                }
            }
        }

        public List<Difference> differences() {
            for (Map.Entry<CountsKey, Register.DoubleLongRegister> entry : this.counts.entrySet()) {
                Register.DoubleLongRegister value = entry.getValue();
                this.differences.add(new Difference(entry.getKey(), value.readFirst(), value.readSecond(), 0L, 0L));
            }
            this.counts.clear();
            return this.differences;
        }
    }

    private static class CommandCollector
    extends CountsVisitor.Adapter {
        private final Collection<Command> commands;

        CommandCollector(Collection<Command> commands) {
            this.commands = commands;
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            if (count != 0L) {
                this.commands.add(new Command.NodeCountsCommand().init(labelId, count));
            }
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            if (count != 0L) {
                this.commands.add(new Command.RelationshipCountsCommand().init(startLabelId, typeId, endLabelId, count));
            }
        }
    }

    public static final class Difference {
        private final CountsKey key;
        private final long expectedFirst;
        private final long expectedSecond;
        private final long actualFirst;
        private final long actualSecond;

        public Difference(CountsKey key, long expectedFirst, long expectedSecond, long actualFirst, long actualSecond) {
            this.expectedFirst = expectedFirst;
            this.expectedSecond = expectedSecond;
            this.actualFirst = actualFirst;
            this.actualSecond = actualSecond;
            this.key = Objects.requireNonNull(key, "key");
        }

        public String toString() {
            return String.format("%s[%s expected=%d:%d, actual=%d:%d]", this.getClass().getSimpleName(), this.key, this.expectedFirst, this.expectedSecond, this.actualFirst, this.actualSecond);
        }

        public CountsKey key() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Difference) {
                Difference that = (Difference)obj;
                return this.actualFirst == that.actualFirst && this.expectedFirst == that.expectedFirst && this.actualSecond == that.actualSecond && this.expectedSecond == that.expectedSecond && this.key.equals(that.key);
            }
            return false;
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (int)(this.expectedFirst ^ this.expectedFirst >>> 32);
            result = 31 * result + (int)(this.expectedSecond ^ this.expectedSecond >>> 32);
            result = 31 * result + (int)(this.actualFirst ^ this.actualFirst >>> 32);
            result = 31 * result + (int)(this.actualSecond ^ this.actualSecond >>> 32);
            return result;
        }
    }
}

