/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class LegacyIndexApplier
extends NeoCommandHandler.Adapter {
    private final LegacyIndexApplierLookup applierLookup;
    private Map<String, NeoCommandHandler> applierByNodeIndex = Collections.emptyMap();
    private Map<String, NeoCommandHandler> applierByRelationshipIndex = Collections.emptyMap();
    private Map<String, NeoCommandHandler> applierByProvider = Collections.emptyMap();
    private final IndexConfigStore indexConfigStore;
    private final IdOrderingQueue transactionOrdering;
    private final long transactionId;
    private final TransactionApplicationMode mode;
    private IndexDefineCommand defineCommand;

    public LegacyIndexApplier(IndexConfigStore indexConfigStore, LegacyIndexApplierLookup applierLookup, IdOrderingQueue transactionOrdering, long transactionId, TransactionApplicationMode mode) {
        this.indexConfigStore = indexConfigStore;
        this.applierLookup = applierLookup;
        this.transactionOrdering = transactionOrdering;
        this.transactionId = transactionId;
        this.mode = mode;
    }

    private NeoCommandHandler applier(IndexCommand command) throws IOException {
        String indexName = this.defineCommand.getIndexName(command.getIndexNameId());
        Map<String, NeoCommandHandler> applierByIndex = this.applierByIndexMap(command);
        NeoCommandHandler applier = applierByIndex.get(indexName);
        if (applier == null) {
            IndexEntityType entityType = IndexEntityType.byId(command.getEntityType());
            Map<String, String> config = this.indexConfigStore.get(entityType.entityClass(), indexName);
            if (config == null) {
                return NeoCommandHandler.EMPTY;
            }
            String providerName = config.get("provider");
            applier = this.applierByProvider.get(providerName);
            if (applier == null) {
                applier = this.applierLookup.newApplier(providerName, this.mode.needsIdempotencyChecks());
                applier.visitIndexDefineCommand(this.defineCommand);
                this.applierByProvider.put(providerName, applier);
            }
            applierByIndex.put(indexName, applier);
        }
        return applier;
    }

    private Map<String, NeoCommandHandler> applierByIndexMap(IndexCommand command) {
        if (command.getEntityType() == IndexEntityType.Node.id()) {
            if (this.applierByNodeIndex.isEmpty()) {
                this.applierByNodeIndex = new HashMap<String, NeoCommandHandler>();
                this.lazyCreateApplierByprovider();
            }
            return this.applierByNodeIndex;
        }
        if (command.getEntityType() == IndexEntityType.Relationship.id()) {
            if (this.applierByRelationshipIndex.isEmpty()) {
                this.applierByRelationshipIndex = new HashMap<String, NeoCommandHandler>();
                this.lazyCreateApplierByprovider();
            }
            return this.applierByRelationshipIndex;
        }
        throw new UnsupportedOperationException("Unknown entity type " + command.getEntityType());
    }

    private void lazyCreateApplierByprovider() {
        if (this.applierByProvider.isEmpty()) {
            this.applierByProvider = new HashMap<String, NeoCommandHandler>();
        }
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        return this.applier(command).visitIndexAddNodeCommand(command);
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        return this.applier(command).visitIndexAddRelationshipCommand(command);
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        return this.applier(command).visitIndexRemoveCommand(command);
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        return this.applier(command).visitIndexDeleteCommand(command);
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        this.indexConfigStore.setIfNecessary(IndexEntityType.byId(command.getEntityType()).entityClass(), this.defineCommand.getIndexName(command.getIndexNameId()), command.getConfig());
        return this.applier(command).visitIndexCreateCommand(command);
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        this.defineCommand = command;
        return false;
    }

    @Override
    public void apply() {
        for (NeoCommandHandler applier : this.applierByProvider.values()) {
            applier.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (NeoCommandHandler applier : this.applierByProvider.values()) {
                applier.close();
            }
        }
        finally {
            if (this.containsLegacyIndexCommands()) {
                this.notifyLegacyIndexOperationQueue();
            }
        }
    }

    private boolean containsLegacyIndexCommands() {
        return this.defineCommand != null;
    }

    private void notifyLegacyIndexOperationQueue() {
        this.transactionOrdering.removeChecked(this.transactionId);
    }
}

