/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.BiConsumer;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;

public final class IndexMap
implements Cloneable {
    private final Map<Long, IndexProxy> indexesById;
    private final Map<IndexDescriptor, IndexProxy> indexesByDescriptor;

    public IndexMap() {
        this(new HashMap<Long, IndexProxy>(), new HashMap<IndexDescriptor, IndexProxy>());
    }

    private IndexMap(Map<Long, IndexProxy> indexesById, Map<IndexDescriptor, IndexProxy> indexesByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
    }

    public IndexProxy getIndexProxy(long indexId) {
        return this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(IndexDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public void putIndexProxy(long indexId, IndexProxy indexProxy) {
        this.indexesById.put(indexId, indexProxy);
        this.indexesByDescriptor.put(indexProxy.getDescriptor(), indexProxy);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = this.indexesById.remove(indexId);
        if (null != removedProxy) {
            this.indexesByDescriptor.remove(removedProxy.getDescriptor());
        }
        return removedProxy;
    }

    public void foreachIndexProxy(BiConsumer<Long, IndexProxy> consumer) {
        for (Map.Entry<Long, IndexProxy> entry : this.indexesById.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public IndexMap clone() {
        return new IndexMap(this.cloneMap(this.indexesById), this.cloneMap(this.indexesByDescriptor));
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map.size());
        shallowCopy.putAll(map);
        return shallowCopy;
    }

    public Iterator<IndexDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public int size() {
        return this.indexesById.size();
    }
}

