/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class IndexUpdatesValidator {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final PropertyLoader propertyLoader;
    private final IndexingService indexing;

    public IndexUpdatesValidator(NeoStore neoStore, PropertyLoader propertyLoader, IndexingService indexing) {
        this.nodeStore = neoStore.getNodeStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.propertyLoader = propertyLoader;
        this.indexing = indexing;
    }

    public ValidatedIndexUpdates validate(TransactionRepresentation transaction, TransactionApplicationMode mode) throws IOException {
        NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
        transaction.accept(extractor);
        if (extractor.noCommandsExtracted()) {
            return ValidatedIndexUpdates.NONE;
        }
        if (mode == TransactionApplicationMode.RECOVERY) {
            return IndexUpdatesValidator.newValidatedRecoveredUpdates(extractor.changedNodeIds(), this.indexing);
        }
        LazyIndexUpdates updates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, extractor.propertyCommandsByNodeIds, extractor.nodeCommandsById);
        return this.indexing.validate(updates);
    }

    private static ValidatedIndexUpdates newValidatedRecoveredUpdates(final PrimitiveLongSet nodeIds, final IndexingService indexing) {
        return new ValidatedIndexUpdates(){

            @Override
            public void flush() {
                indexing.addRecoveredNodeIds(nodeIds);
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasChanges() {
                return !nodeIds.isEmpty();
            }
        };
    }

    private static class NodePropertyCommandsExtractor
    extends NeoCommandHandler.Adapter
    implements Visitor<Command, IOException> {
        final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommandsById = Primitive.longObjectMap((int)16);
        final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds = Primitive.longObjectMap((int)16);

        private NodePropertyCommandsExtractor() {
        }

        @Override
        public boolean visit(Command element) throws IOException {
            element.handle(this);
            return false;
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            this.nodeCommandsById.put(command.getKey(), (Object)command);
            return false;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            PropertyRecord record = command.getAfter();
            if (record.isNodeSet()) {
                long nodeId = command.getAfter().getNodeId();
                ArrayList<Command.PropertyCommand> group = (ArrayList<Command.PropertyCommand>)this.propertyCommandsByNodeIds.get(nodeId);
                if (group == null) {
                    group = new ArrayList<Command.PropertyCommand>();
                    this.propertyCommandsByNodeIds.put(nodeId, group);
                }
                group.add(command);
            }
            return false;
        }

        boolean noCommandsExtracted() {
            return this.nodeCommandsById.isEmpty() && this.propertyCommandsByNodeIds.isEmpty();
        }

        PrimitiveLongSet changedNodeIds() {
            PrimitiveLongSet nodeIds = Primitive.longSet((int)(this.nodeCommandsById.size() + this.propertyCommandsByNodeIds.size()));
            this.nodeCommandsById.visitKeys(this.copyTo(nodeIds));
            this.propertyCommandsByNodeIds.visitKeys(this.copyTo(nodeIds));
            return nodeIds;
        }

        PrimitiveLongVisitor<RuntimeException> copyTo(final PrimitiveLongSet set) {
            return new PrimitiveLongVisitor<RuntimeException>(){

                public boolean visited(long value) {
                    set.add(value);
                    return false;
                }
            };
        }
    }
}

