/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import org.neo4j.helpers.Predicate;

public class IndexSamplingJobQueue<T> {
    private final Queue<T> queue = new ArrayDeque<T>();
    private final Predicate<? super T> enqueueablePredicate;

    public IndexSamplingJobQueue(Predicate<? super T> enqueueablePredicate) {
        this.enqueueablePredicate = enqueueablePredicate;
    }

    public synchronized void add(boolean force, T item) {
        if (this.shouldEnqueue(force, item)) {
            this.queue.add(item);
        }
    }

    public synchronized void addAll(boolean force, Iterator<T> items) {
        while (items.hasNext()) {
            this.add(force, items.next());
        }
    }

    private boolean shouldEnqueue(boolean force, T item) {
        if (this.queue.contains(item)) {
            return false;
        }
        if (force) {
            return true;
        }
        return this.enqueueablePredicate.accept(item);
    }

    public synchronized T poll() {
        return this.queue.poll();
    }

    public synchronized Iterable<T> pollAll() {
        ArrayList<T> items = new ArrayList<T>(this.queue.size());
        T item;
        while ((item = this.queue.poll()) != null) {
            items.add(item);
        }
        return items;
    }
}

