/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelationshipFilter;

public class DenseNodeImpl
extends NodeImpl {
    public DenseNodeImpl(long id) {
        super(id);
    }

    @Override
    public int getDegree(RelationshipLoader relationshipLoader, int type, CacheUpdateListener cacheUpdateListener) {
        return this.getDegree(relationshipLoader, type, Direction.BOTH, cacheUpdateListener);
    }

    @Override
    public int getDegree(RelationshipLoader relationshipLoader, Direction direction, CacheUpdateListener cacheUpdateListener) {
        return relationshipLoader.getRelationshipCount(this.getId(), -1, RelIdArray.wrap(direction));
    }

    @Override
    public int getDegree(RelationshipLoader relationshipLoader, int type, Direction direction, CacheUpdateListener cacheUpdateListener) {
        return relationshipLoader.getRelationshipCount(this.getId(), type, RelIdArray.wrap(direction));
    }

    @Override
    public Iterator<Integer> getRelationshipTypes(RelationshipLoader relationshipLoader, CacheUpdateListener cacheUpdateListener) {
        return this.hasMoreRelationshipsToLoad() ? IteratorUtil.iterator(relationshipLoader.getRelationshipTypes(this.getId())) : super.getRelationshipTypes(relationshipLoader, cacheUpdateListener);
    }

    @Override
    public void visitDegrees(RelationshipLoader relationshipLoader, DegreeVisitor visitor, CacheUpdateListener cacheUpdateListener) {
        relationshipLoader.visitRelationshipCounts(this.getId(), visitor);
    }

    @Override
    protected boolean isDense() {
        return true;
    }

    @Override
    protected RelationshipFilter filterForAddingRelationships(final FirstRelationshipIds firstRelationshipIdsToCommit, final RelationshipLoadingPosition relChainPosition) {
        return new RelationshipFilter(){

            @Override
            public boolean accept(int type, RelIdArray.DirectionWrapper direction, long firstCachedId) {
                long firstIdToCommit = firstRelationshipIdsToCommit.firstIdOf(type, direction);
                assert (firstIdToCommit != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) : "About to add relationships of " + type + " " + (Object)((Object)direction) + " to node " + DenseNodeImpl.this.getId() + ", but apparently the tx state says that no such relationships " + "are to be added " + firstRelationshipIdsToCommit;
                return firstCachedId == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? this.relationshipChainAtPosition(relChainPosition, direction, type, firstIdToCommit) : firstCachedId != firstIdToCommit;
            }

            private boolean relationshipChainAtPosition(RelationshipLoadingPosition relChainPosition2, RelIdArray.DirectionWrapper direction, int type, long firstIdToCommit) {
                return relChainPosition2 != null && !relChainPosition2.atPosition(direction, type, firstIdToCommit);
            }
        };
    }
}

