/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, new Config());
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config) {
        Config baseConfig = new Config(MapUtil.stringMap(GraphDatabaseSettings.pagecache_memory.name(), "8M"));
        Config finalConfig = baseConfig.with(config.getParams());
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, finalConfig, PageCacheTracer.NULL);
        return pageCacheFactory.getOrCreatePageCache();
    }
}

