/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class DumpStoreChain<RECORD extends AbstractBaseRecord> {
    private static final String REVERSE = "reverse";
    private static final String NODE = "node";
    private static final String FIRST = "first";
    private static final String RELS = "relationships";
    private static final String PROPS = "properties";
    private static final String RELSTORE = "neostore.relationshipstore.db";
    private static final String PROPSTORE = "neostore.propertystore.db";
    private static final String NODESTORE = "neostore.nodestore.db";
    long first;

    public static void main(String ... args) throws Exception {
        DumpStoreChain tool;
        Args arguments = Args.withFlags(REVERSE, RELS, PROPS).parse(args);
        List<String> orphans = arguments.orphans();
        if (orphans.size() != 1) {
            throw DumpStoreChain.invalidUsage("no store file given");
        }
        File storeFile = new File(orphans.get(0));
        if (storeFile.isDirectory()) {
            DumpStoreChain.verifyFilesExists(new File(storeFile, NODESTORE), new File(storeFile, RELSTORE), new File(storeFile, PROPSTORE));
            tool = DumpStoreChain.chainForNode(arguments);
        } else {
            DumpStoreChain.verifyFilesExists(storeFile);
            if (RELSTORE.equals(storeFile.getName())) {
                tool = DumpStoreChain.relationshipChain(arguments);
            } else if (PROPSTORE.equals(storeFile.getName())) {
                tool = DumpStoreChain.propertyChain(arguments);
            } else {
                throw DumpStoreChain.invalidUsage("not a chain store: " + storeFile.getName());
            }
        }
        tool.dump(storeFile);
    }

    private DumpStoreChain(long first) {
        this.first = first;
    }

    private static StringLogger logger() {
        return Boolean.getBoolean("logger") ? StringLogger.SYSTEM : StringLogger.DEV_NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(File storeFile) throws IOException {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);){
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
            Config config = new Config();
            StoreFactory storeFactory = new StoreFactory(config, idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, DumpStoreChain.logger(), null);
            try (RecordStore<RECORD> store = this.store(storeFactory, storeFile);){
                long next = this.first;
                while (next != -1L) {
                    RECORD record = store.forceGetRecord(next);
                    System.out.println(record);
                    next = this.next(record);
                }
            }
        }
    }

    abstract long next(RECORD var1);

    abstract RecordStore<RECORD> store(StoreFactory var1, File var2);

    private static DumpStoreChain propertyChain(Args args) {
        boolean reverse = DumpStoreChain.verifyParametersAndCheckReverse(args, FIRST);
        return new DumpPropertyChain(Long.parseLong(args.get(FIRST, null)), reverse);
    }

    private static DumpStoreChain relationshipChain(Args args) {
        boolean reverse = DumpStoreChain.verifyParametersAndCheckReverse(args, FIRST, NODE);
        long node = Long.parseLong(args.get(NODE, null));
        return new DumpRelationshipChain(Long.parseLong(args.get(FIRST, null)), node, reverse);
    }

    private static DumpStoreChain chainForNode(Args args) {
        Set<String> kwArgs = args.asMap().keySet();
        DumpStoreChain.verifyParameters(kwArgs, kwArgs.contains(RELS) ? RELS : PROPS, NODE);
        final long node = Long.parseLong(args.get(NODE, null));
        if (args.getBoolean(RELS, false, true).booleanValue()) {
            return new DumpRelationshipChain(-1L, node, false){

                @Override
                RelationshipStore store(StoreFactory factory, File storeFile) {
                    NodeRecord nodeRecord = DumpStoreChain.nodeRecord(factory, storeFile, node);
                    this.first = nodeRecord.isDense() ? -1L : nodeRecord.getNextRel();
                    return super.store(factory, new File(storeFile, DumpStoreChain.RELSTORE));
                }
            };
        }
        if (args.getBoolean(PROPS, false, true).booleanValue()) {
            return new DumpPropertyChain(-1L, false){

                @Override
                PropertyStore store(StoreFactory factory, File storeFile) {
                    this.first = DumpStoreChain.nodeRecord(factory, storeFile, node).getNextProp();
                    return super.store(factory, new File(storeFile, DumpStoreChain.PROPSTORE));
                }
            };
        }
        throw DumpStoreChain.invalidUsage(String.format("Must be either -%s or -%s", RELS, PROPS));
    }

    private static NodeRecord nodeRecord(StoreFactory factory, File storeDir, long id) {
        try (NodeStore store = factory.newNodeStore(new File(storeDir, NODESTORE));){
            NodeRecord nodeRecord = store.forceGetRecord(id);
            return nodeRecord;
        }
    }

    private static void verifyFilesExists(File ... files) {
        for (File file : files) {
            if (file.isFile()) continue;
            throw DumpStoreChain.invalidUsage(file + " does not exist");
        }
    }

    private static boolean verifyParametersAndCheckReverse(Args args, String ... parameters) {
        Set<String> kwArgs = args.asMap().keySet();
        if (kwArgs.contains(REVERSE)) {
            parameters = Arrays.copyOf(parameters, parameters.length + 1);
            parameters[parameters.length - 1] = REVERSE;
        }
        DumpStoreChain.verifyParameters(kwArgs, parameters);
        return args.getBoolean(REVERSE, false, true);
    }

    private static void verifyParameters(Set<String> args, String ... parameters) {
        if (args.size() != parameters.length) {
            throw DumpStoreChain.invalidUsage("accepted/required parameters: " + Arrays.toString(parameters));
        }
        for (String parameter : parameters) {
            if (args.contains(parameter)) continue;
            throw DumpStoreChain.invalidUsage("accepted/required parameters: " + Arrays.toString(parameters));
        }
    }

    private static Error invalidUsage(String message) {
        System.err.println("invalid usage: " + message);
        System.exit(1);
        return null;
    }

    private static class DumpRelationshipChain
    extends DumpStoreChain<RelationshipRecord> {
        private final long node;
        private final boolean reverse;

        DumpRelationshipChain(long first, long node, boolean reverse) {
            super(first);
            this.node = node;
            this.reverse = reverse;
        }

        RelationshipStore store(StoreFactory factory, File storeFile) {
            return factory.newRelationshipStore(storeFile);
        }

        @Override
        long next(RelationshipRecord record) {
            if (record.getFirstNode() == this.node) {
                return this.reverse ? record.getFirstPrevRel() : record.getFirstNextRel();
            }
            if (record.getSecondNode() == this.node) {
                return this.reverse ? record.getSecondPrevRel() : record.getSecondNextRel();
            }
            return -1L;
        }
    }

    private static class DumpPropertyChain
    extends DumpStoreChain<PropertyRecord> {
        private final boolean reverse;

        DumpPropertyChain(long first, boolean reverse) {
            super(first);
            this.reverse = reverse;
        }

        PropertyStore store(StoreFactory factory, File storeFile) {
            return factory.newPropertyStore(storeFile);
        }

        @Override
        long next(PropertyRecord record) {
            return this.reverse ? record.getPrevProp() : record.getNextProp();
        }
    }
}

