/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.util.Charsets;

public abstract class StoreVersionTrailerUtil {
    public static long getTrailerOffset(PagedFile pagedFile, String expectedTrailer) throws IOException {
        int trailerPositionRelativeToFirstPageTrailerMightBeIn;
        int pageSize = pagedFile.pageSize();
        int expectedTrailerLength = UTF8.encode(expectedTrailer).length;
        long lastPageId = pagedFile.getLastPageId();
        long firstPageThatTrailerMightBeIn = StoreVersionTrailerUtil.getFirstPageThatTrailerMightBeIn(lastPageId, pageSize, expectedTrailerLength);
        try (PageCursor pageCursor = pagedFile.io(firstPageThatTrailerMightBeIn, 1);){
            byte[] allData = StoreVersionTrailerUtil.getTheBytesThatWillContainTheTrailer(pageSize, firstPageThatTrailerMightBeIn, lastPageId, pageCursor);
            trailerPositionRelativeToFirstPageTrailerMightBeIn = StoreVersionTrailerUtil.findTrailerPositionInArray(allData, UTF8.encode(expectedTrailer.split(" ")[0]));
        }
        if (trailerPositionRelativeToFirstPageTrailerMightBeIn == -1) {
            return trailerPositionRelativeToFirstPageTrailerMightBeIn;
        }
        return (long)trailerPositionRelativeToFirstPageTrailerMightBeIn + firstPageThatTrailerMightBeIn * (long)pageSize;
    }

    public static String readTrailer(PagedFile pagedFile, String expectedTrailer) throws IOException {
        String version = null;
        int pageSize = pagedFile.pageSize();
        int encodedExpectedTrailerLength = UTF8.encode(expectedTrailer).length;
        long lastPageId = pagedFile.getLastPageId();
        long firstPageThatTrailerMightBeIn = StoreVersionTrailerUtil.getFirstPageThatTrailerMightBeIn(lastPageId, pageSize, encodedExpectedTrailerLength);
        try (PageCursor pageCursor = pagedFile.io(firstPageThatTrailerMightBeIn, 1);){
            byte[] data = StoreVersionTrailerUtil.getTheBytesThatWillContainTheTrailer(pageSize, firstPageThatTrailerMightBeIn, lastPageId, pageCursor);
            int trailerPositionRelativeToFirstPageTrailerMightBeIn = StoreVersionTrailerUtil.findTrailerPositionInArray(data, UTF8.encode(expectedTrailer.split(" ")[0]));
            if (trailerPositionRelativeToFirstPageTrailerMightBeIn != -1) {
                version = new String(data, trailerPositionRelativeToFirstPageTrailerMightBeIn, encodedExpectedTrailerLength, Charsets.UTF_8);
            }
        }
        return version;
    }

    public static void writeTrailer(PagedFile pagedFile, byte[] trailer, long trailerOffset) throws IOException {
        int pageSize = pagedFile.pageSize();
        long pageIdTrailerStartsIn = trailerOffset / (long)pageSize;
        try (PageCursor pageCursor = pagedFile.io(pageIdTrailerStartsIn, 2);){
            int writtenOffset = 0;
            while (writtenOffset < trailer.length) {
                pageCursor.next();
                pageCursor.setOffset((int)(((long)writtenOffset + trailerOffset) % (long)pageSize));
                do {
                    pageCursor.putByte(trailer[writtenOffset]);
                } while (pageCursor.shouldRetry() || ((long)(++writtenOffset) + trailerOffset) % (long)pageSize != 0L && writtenOffset < trailer.length);
            }
        }
    }

    private static long getFirstPageThatTrailerMightBeIn(long lastPageId, int pageSize, int expectedTrailerLength) throws IOException {
        int maximumNumberOfPagesVersionSpans = StoreVersionTrailerUtil.getMaximumNumberOfPagesVersionSpans(expectedTrailerLength, pageSize);
        return Math.max(lastPageId + 1L - (long)maximumNumberOfPagesVersionSpans, 0L);
    }

    private static int findTrailerPositionInArray(byte[] dataThatShouldContainTrailer, byte[] trailer) {
        for (int i = dataThatShouldContainTrailer.length - trailer.length; i >= 0; --i) {
            int pos;
            for (pos = 0; pos < trailer.length && dataThatShouldContainTrailer[i + pos] == trailer[pos]; ++pos) {
            }
            if (pos != trailer.length) continue;
            return i;
        }
        return -1;
    }

    private static int getMaximumNumberOfPagesVersionSpans(int trailerLength, int pageSize) {
        return trailerLength / pageSize + 2;
    }

    private static byte[] getTheBytesThatWillContainTheTrailer(int pageSize, long firstPageThatTrailerMightBeIn, long lastPageId, PageCursor pageCursor) throws IOException {
        byte[] allData = new byte[(int)((long)pageSize * (lastPageId - firstPageThatTrailerMightBeIn + 1L))];
        byte[] data = new byte[pageSize];
        int currentPage = 0;
        while (pageCursor.next()) {
            do {
                pageCursor.getBytes(data);
            } while (pageCursor.shouldRetry());
            System.arraycopy(data, 0, allData, currentPage * data.length, data.length);
            ++currentPage;
        }
        return allData;
    }
}

