/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.record.NeoStoreUtil;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public boolean storeFilesUpgradeable(File storeDirectory) {
        try {
            this.checkUpgradeable(storeDirectory);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public String checkUpgradeable(File storeDirectory) {
        StoreVersionCheck.Result result = this.checkUpgradeableFor(storeDirectory, "v0.A.0");
        if (result.outcome.isSuccessful()) {
            return "v0.A.0";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.1");
        if (result.outcome.isSuccessful()) {
            return "v0.A.1";
        }
        result = this.checkUpgradeableFor(storeDirectory, "v0.A.3");
        if (result.outcome.isSuccessful()) {
            return "v0.A.3";
        }
        switch (result.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(result.storeFilename);
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(result.storeFilename);
            }
            case unexpectedUpgradingStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(result.storeFilename, "v0.A.3", result.actualVersion);
            }
        }
        throw new IllegalArgumentException(result.outcome.name());
    }

    private StoreVersionCheck.Result checkUpgradeableFor(File storeDirectory, String version) {
        StoreVersionCheck.Result result = null;
        for (StoreFile store : StoreFile.legacyStoreFilesForVersion(version)) {
            String expectedVersion = store.forVersion(version);
            File storeFile = new File(storeDirectory, store.storeFileName());
            result = this.storeVersionCheck.hasVersion(storeFile, expectedVersion);
            if (result.outcome.isSuccessful()) continue;
            break;
        }
        return result;
    }

    public boolean hasCurrentVersion(FileSystemAbstraction fs, File storeDir) {
        NeoStoreUtil neoStoreUtil = new NeoStoreUtil(storeDir, fs);
        String versionAsString = NeoStore.versionLongToString(neoStoreUtil.getStoreVersion());
        return "v0.A.5".equals(versionAsString);
    }
}

