/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.Collection;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public abstract class CommandReaderFactory {
    public static final DynamicRecordAdder<PropertyBlock> PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyBlock>(){

        @Override
        public void add(PropertyBlock target, DynamicRecord record) {
            record.setCreated();
            target.addValueRecord(record);
        }
    };
    public static final DynamicRecordAdder<Collection<DynamicRecord>> COLLECTION_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<Collection<DynamicRecord>>(){

        @Override
        public void add(Collection<DynamicRecord> target, DynamicRecord record) {
            target.add(record);
        }
    };
    public static final DynamicRecordAdder<PropertyRecord> PROPERTY_DELETED_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyRecord>(){

        @Override
        public void add(PropertyRecord target, DynamicRecord record) {
            assert (!record.inUse()) : record + " is kinda weird";
            target.addDeletedRecord(record);
        }
    };
    public static final DynamicRecordAdder<PropertyKeyTokenRecord> PROPERTY_INDEX_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyKeyTokenRecord>(){

        @Override
        public void add(PropertyKeyTokenRecord target, DynamicRecord record) {
            target.addNameRecord(record);
        }
    };

    public static interface DynamicRecordAdder<T> {
        public void add(T var1, DynamicRecord var2);
    }
}

