/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class IndexTransactionApplier
extends NeoCommandHandler.Adapter {
    private final ValidatedIndexUpdates indexUpdates;
    private List<NodeLabelUpdate> labelUpdates;
    private final IndexingService indexingService;
    private final CacheAccessBackDoor cacheAccess;
    private final WorkSync<Provider<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync;

    public IndexTransactionApplier(IndexingService indexingService, ValidatedIndexUpdates indexUpdates, WorkSync<Provider<LabelScanWriter>, LabelUpdateWork> labelScanStoreSync, CacheAccessBackDoor cacheAccess) {
        this.indexingService = indexingService;
        this.indexUpdates = indexUpdates;
        this.labelScanStoreSync = labelScanStoreSync;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void apply() {
        try {
            if (this.labelUpdates != null) {
                this.updateLabelScanStore();
                this.cacheAccess.applyLabelUpdates(this.labelUpdates);
            }
            if (this.indexUpdates.hasChanges()) {
                this.updateIndexes();
            }
        }
        catch (IOException | IndexCapacityExceededException | IndexEntryConflictException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexes() throws IOException, IndexCapacityExceededException, IndexEntryConflictException {
        IndexingService indexingService = this.indexingService;
        synchronized (indexingService) {
            this.indexUpdates.flush();
        }
    }

    private void updateLabelScanStore() {
        this.labelScanStoreSync.apply((Work)new LabelUpdateWork(this.labelUpdates));
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
        NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
        if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
            long[] labelsBefore = labelFieldBefore.getIfLoaded();
            long[] labelsAfter = labelFieldAfter.getIfLoaded();
            if (labelsBefore != null && labelsAfter != null) {
                this.addLabelUpdate(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter));
            }
        }
        return false;
    }

    private void addLabelUpdate(NodeLabelUpdate labelChanges) {
        if (this.labelUpdates == null) {
            this.labelUpdates = new ArrayList<NodeLabelUpdate>();
        }
        this.labelUpdates.add(labelChanges);
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        if (command.getSchemaRule() instanceof IndexRule) {
            switch (command.getMode()) {
                case UPDATE: {
                    if (!((IndexRule)command.getSchemaRule()).isConstraintIndex()) break;
                    try {
                        this.indexingService.activateIndex(command.getSchemaRule().getId());
                        break;
                    }
                    catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                        throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                    }
                }
                case CREATE: {
                    this.indexingService.createIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                case DELETE: {
                    this.indexingService.dropIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        return false;
    }

    public static class LabelUpdateWork
    implements Work<Provider<LabelScanWriter>, LabelUpdateWork> {
        private final List<NodeLabelUpdate> labelUpdates;

        public LabelUpdateWork(List<NodeLabelUpdate> labelUpdates) {
            this.labelUpdates = labelUpdates;
        }

        public LabelUpdateWork combine(LabelUpdateWork work) {
            this.labelUpdates.addAll(work.labelUpdates);
            return this;
        }

        public void apply(Provider<LabelScanWriter> labelScanStore) {
            Collections.sort(this.labelUpdates, NodeLabelUpdate.SORT_BY_NODE_ID);
            try (LabelScanWriter writer = labelScanStore.instance();){
                for (NodeLabelUpdate update : this.labelUpdates) {
                    writer.write(update);
                }
            }
            catch (Exception e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }
}

