/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.IndexCommandDetector;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

class BatchingTransactionAppender
implements TransactionAppender {
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final WritableLogChannel channel;
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final TransactionLogWriter transactionLogWriter;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final IndexCommandDetector indexCommandDetector;
    private final KernelHealth kernelHealth;
    private final Lock forceLock;

    public BatchingTransactionAppender(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering, KernelHealth kernelHealth) {
        this.logFile = logFile;
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.kernelHealth = kernelHealth;
        this.channel = logFile.getWriter();
        this.transactionMetadataCache = transactionMetadataCache;
        this.indexCommandDetector = new IndexCommandDetector(new CommandWriter(this.channel));
        this.transactionLogWriter = new TransactionLogWriter(new LogEntryWriter(this.channel, this.indexCommandDetector));
        this.forceLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(TransactionRepresentation transaction, LogAppendEvent logAppendEvent) throws IOException {
        long transactionId = -1L;
        int phase = 0;
        logAppendEvent.setLogRotated(this.logRotation.rotateLogIfNeeded(logAppendEvent));
        try {
            TransactionCommitment commit;
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                try (SerializeTransactionEvent serialiseEvent = logAppendEvent.beginSerializeTransaction();){
                    transactionId = this.transactionIdStore.nextCommittingTransactionId();
                    phase = 1;
                    commit = this.appendToLog(transaction, transactionId);
                }
            }
            this.forceAfterAppend(logAppendEvent);
            commit.publishAsCommitted();
            this.orderLegacyIndexChanges(commit);
            phase = 2;
            long l = transactionId;
            return l;
        }
        finally {
            if (phase == 1) {
                this.transactionIdStore.transactionClosed(transactionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Commitment append(TransactionRepresentation transaction, long expectedTransactionId) throws IOException {
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            long transactionId = this.transactionIdStore.nextCommittingTransactionId();
            if (transactionId != expectedTransactionId) {
                throw new ThisShouldNotHappenError("Zhen Li and Mattias Persson", "Received " + transaction + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            }
            return this.appendToLog(transaction, transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionCommitment appendToLog(TransactionRepresentation transaction, long transactionId) throws IOException {
        this.indexCommandDetector.reset();
        try {
            LogPosition logPosition;
            WritableLogChannel writableLogChannel = this.channel;
            synchronized (writableLogChannel) {
                logPosition = this.channel.getCurrentPosition(this.positionMarker).newPosition();
                this.transactionLogWriter.append(transaction, transactionId);
            }
            long transactionChecksum = LogEntryStart.checksum(transaction.additionalHeader(), transaction.getMasterId(), transaction.getAuthorId());
            this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPosition, transaction.getMasterId(), transaction.getAuthorId(), transactionChecksum);
            boolean hasLegacyIndexChanges = this.indexCommandDetector.hasWrittenAnyLegacyIndexCommand();
            if (hasLegacyIndexChanges) {
                this.legacyIndexTransactionOrdering.offer(transactionId);
            }
            return new TransactionCommitment(hasLegacyIndexChanges, transactionId, transactionChecksum, this.transactionIdStore);
        }
        catch (Throwable panic) {
            this.kernelHealth.panic(panic);
            throw panic;
        }
    }

    private void orderLegacyIndexChanges(TransactionCommitment commit) throws IOException {
        if (commit.hasLegacyIndexChanges) {
            try {
                this.legacyIndexTransactionOrdering.waitFor(commit.transactionId);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while waiting for applying legacy index updates", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceAfterAppend(LogAppendEvent logAppendEvent) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        try (LogForceWaitEvent logForceWaitEvent = logAppendEvent.beginLogForceWait();){
            do {
                if (this.forceLock.tryLock()) {
                    try {
                        this.forceLog(logAppendEvent);
                    }
                    finally {
                        this.forceLock.unlock();
                        ThreadLink nextWaiter = this.threadLinkHead.get();
                        nextWaiter.unpark();
                    }
                } else {
                    this.waitForLogForce();
                }
            } while (!threadLink.done);
        }
    }

    private void forceLog(LogAppendEvent logAppendEvent) throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        try (LogForceEvent logForceEvent = logAppendEvent.beginLogForce();){
            this.force();
        }
        this.unparkAll(links);
    }

    private void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private void waitForLogForce() {
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() throws IOException {
        WritableLogChannel writableLogChannel = this.channel;
        synchronized (writableLogChannel) {
            this.channel.emptyBufferIntoChannelAndClearIt();
        }
        this.channel.force();
    }

    private static class TransactionCommitment
    implements Commitment {
        private final boolean hasLegacyIndexChanges;
        private final long transactionId;
        private final long transactionChecksum;
        private final TransactionIdStore transactionIdStore;

        TransactionCommitment(boolean hasLegacyIndexChanges, long transactionId, long transactionChecksum, TransactionIdStore transactionIdStore) {
            this.hasLegacyIndexChanges = hasLegacyIndexChanges;
            this.transactionId = transactionId;
            this.transactionChecksum = transactionChecksum;
            this.transactionIdStore = transactionIdStore;
        }

        @Override
        public void publishAsCommitted() {
            this.transactionIdStore.transactionCommitted(this.transactionId, this.transactionChecksum);
        }
    }

    private static class ThreadLink {
        final Thread thread;
        volatile ThreadLink next;
        volatile boolean done;
        static final ThreadLink END;

        public ThreadLink(Thread thread) {
            this.thread = thread;
        }

        public void unpark() {
            LockSupport.unpark(this.thread);
        }

        static {
            ThreadLink.END.next = END = new ThreadLink(null);
        }
    }
}

