/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.graphdb.Resource;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodePrepareStep;
import org.neo4j.unsafe.impl.batchimport.StripedLock;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CalculateDenseNodesStep
extends ProcessorStep<long[]> {
    private final NodeRelationshipCache cache;
    private final StripedLock lock = new StripedLock(10);

    public CalculateDenseNodesStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, NodeRelationshipCache cache) {
        super(control, "CALCULATOR", (Configuration)config, 10, new StatsProvider[0]);
        this.cache = cache;
    }

    @Override
    protected void process(long[] ids, BatchSender sender) {
        try (Resource automaticallyUnlocked = this.lock.lock(CalculateDenseNodePrepareStep.radixOf(ids[0]));){
            for (long id : ids) {
                if (id == -1L) continue;
                this.cache.incrementCount(id);
            }
        }
    }
}

