/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.HeapNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;

public class HeapLongArray
extends HeapNumberArray
implements LongArray {
    private final long[] array;
    private final long defaultValue;

    public HeapLongArray(int length, long defaultValue) {
        super(8);
        this.defaultValue = defaultValue;
        this.array = new long[length];
        this.clear();
    }

    @Override
    public long length() {
        return this.array.length;
    }

    @Override
    public long get(long index) {
        return this.array[Utils.safeCastLongToInt(index)];
    }

    @Override
    public void set(long index, long value) {
        this.array[Utils.safeCastLongToInt((long)index)] = value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, this.defaultValue);
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long fromValue = this.get(fromIndex + (long)i);
            this.set(fromIndex + (long)i, this.get(toIndex + (long)i));
            this.set(toIndex + (long)i, fromValue);
        }
    }

    @Override
    public LongArray fixate() {
        return this;
    }
}

