/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

abstract class InputEntityReader<ENTITY extends InputEntity>
extends PrefetchingIterator<ENTITY>
implements InputIterator<ENTITY> {
    protected final ReadableLogChannel channel;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private int lineNumber;
    private final Group[] previousGroups;
    private final PrimitiveIntObjectMap<String> tokens = Primitive.intObjectMap();

    InputEntityReader(StoreChannel channel, StoreChannel header, int bufferSize, int groupSlots) throws IOException {
        this.previousGroups = new Group[groupSlots];
        for (int i = 0; i < groupSlots; ++i) {
            this.previousGroups[i] = Group.GLOBAL;
        }
        this.channel = this.reader(channel, bufferSize);
        this.readHeader(header);
    }

    private ReadAheadLogChannel reader(StoreChannel channel, int bufferSize) throws IOException {
        return new ReadAheadLogChannel(new PhysicalLogVersionedStoreChannel(channel, 0L, 0), LogVersionBridge.NO_MORE_CHANNELS, bufferSize);
    }

    private void readHeader(StoreChannel header) throws IOException {
        try (ReadAheadLogChannel reader = this.reader(header, 8 * Format.KB);){
            int id = 0;
            while (reader.get() == 1) {
                this.tokens.put(id, (Object)((String)ValueType.stringType().read(reader)));
                id = (short)(id + 1);
            }
        }
    }

    @Override
    protected final ENTITY fetchNextOrNull() {
        try {
            ++this.lineNumber;
            Object properties = this.readProperties();
            if (properties == null) {
                return null;
            }
            return this.readNextOrNull(properties);
        }
        catch (IOException e) {
            throw new InputException("Couldn't read cached node data", e);
        }
    }

    protected abstract ENTITY readNextOrNull(Object var1) throws IOException;

    private Object readProperties() throws IOException {
        short count = this.channel.getShort();
        switch (count) {
            case -2: {
                return null;
            }
            case -1: {
                return this.channel.getLong();
            }
            case 0: {
                return InputEntity.NO_PROPERTIES;
            }
        }
        Object[] properties = new Object[count * 2];
        for (int i = 0; i < properties.length; ++i) {
            properties[i++] = this.readToken();
            properties[i] = this.readValue();
        }
        return properties;
    }

    protected String readToken() throws IOException {
        short id = this.channel.getShort();
        String name = (String)this.tokens.get((int)id);
        if (name == null) {
            throw new IllegalArgumentException("Unknown token " + id);
        }
        return name;
    }

    protected Object readValue() throws IOException {
        return ValueType.typeOf(this.channel.get()).read(this.channel);
    }

    protected Group readGroup(int slot) throws IOException {
        byte groupMode = this.channel.get();
        switch (groupMode) {
            case 0: {
                return this.previousGroups[slot];
            }
            case 1: {
                this.previousGroups[slot] = new Group.Adapter(this.channel.getInt(), this.readToken());
                return this.previousGroups[slot];
            }
        }
        throw new IllegalArgumentException("Unknown group mode " + groupMode);
    }

    public String sourceDescription() {
        return "cache";
    }

    public long lineNumber() {
        return this.lineNumber;
    }

    public long position() {
        try {
            return this.channel.getCurrentPosition(this.positionMarker).getByteOffset();
        }
        catch (IOException e) {
            throw new InputException("Couldn't get position from cached input data", e);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new InputException("Couldn't close channel for cached input data", e);
        }
    }
}

