/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;

public class IndexSchemaRuleNotFoundException
extends SchemaRuleNotFoundException {
    private static final String UNIQUE_INDEX_PREFIX = "Uniqueness index";
    private static final String INDEX_PREFIX = "Index";
    private static final String INDEX_RULE_NOT_FOUND_MESSAGE_TEMPLATE = "%s for label '%s' and property '%s' not found.";

    public IndexSchemaRuleNotFoundException(int labelId, int propertyKeyId) {
        this(labelId, propertyKeyId, false);
    }

    public IndexSchemaRuleNotFoundException(int labelId, int propertyKeyId, boolean unique) {
        super(INDEX_RULE_NOT_FOUND_MESSAGE_TEMPLATE, labelId, propertyKeyId, unique ? UNIQUE_INDEX_PREFIX : INDEX_PREFIX);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(this.messageTemplate, this.messagePrefix, tokenNameLookup.labelGetName(this.ruleEntityId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }
}

