/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final KernelTransactions transactions;
    private final TransactionHooks hooks;
    private final DatabaseHealth health;
    private final TransactionMonitor transactionMonitor;
    private final Procedures procedures;

    public Kernel(KernelTransactions transactionFactory, TransactionHooks hooks, DatabaseHealth health, TransactionMonitor transactionMonitor, Procedures procedures) {
        this.transactions = transactionFactory;
        this.hooks = hooks;
        this.health = health;
        this.transactionMonitor = transactionMonitor;
        this.procedures = procedures;
    }

    @Override
    public KernelTransaction newTransaction(KernelTransaction.Type type, AccessMode accessMode) throws TransactionFailureException {
        this.health.assertHealthy(TransactionFailureException.class);
        KernelTransaction transaction = this.transactions.newInstance(type, accessMode);
        this.transactionMonitor.transactionStarted();
        return transaction;
    }

    @Override
    public void registerTransactionHook(TransactionHook hook) {
        this.hooks.register(hook);
    }

    @Override
    public void unregisterTransactionHook(TransactionHook hook) {
        this.hooks.unregister(hook);
    }

    @Override
    public void registerProcedure(CallableProcedure signature) throws ProcedureException {
        this.procedures.register(signature);
    }

    public void stop() throws Throwable {
        this.transactions.disposeAll();
    }
}

