/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id.validation;

import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;

public final class IdValidator {
    private IdValidator() {
    }

    public static boolean isReservedId(long id) {
        return id == 0xFFFFFFFFL;
    }

    public static void assertValidId(long id, long maxId) {
        if (IdValidator.isReservedId(id)) {
            throw new ReservedIdException(id);
        }
        IdValidator.assertIdWithinCapacity(id, maxId);
    }

    public static void assertIdWithinCapacity(long id, long maxId) {
        if (id < 0L) {
            throw new NegativeIdException(id);
        }
        if (id > maxId) {
            throw new IdCapacityExceededException(id, maxId);
        }
    }
}

