/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

public class PhysicalTransactionCursor<T extends ReadableClosablePositionAwareChannel>
implements IOCursor<CommittedTransactionRepresentation> {
    private final LogEntryCursor logEntryCursor;
    private final Marker<T> marker;
    private CommittedTransactionRepresentation current;
    private long lastKnownGoodPosition;

    public PhysicalTransactionCursor(T channel, LogEntryReader<T> entryReader) throws IOException {
        this.marker = new Marker<T>(channel);
        this.lastKnownGoodPosition = this.marker.currentPosition();
        this.logEntryCursor = new LogEntryCursor(entryReader, (ReadableClosablePositionAwareChannel)channel);
    }

    protected List<StorageCommand> commandList() {
        return new ArrayList<StorageCommand>();
    }

    public CommittedTransactionRepresentation get() {
        return this.current;
    }

    public boolean next() throws IOException {
        LogEntry entry;
        while (true) {
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            if (!(entry instanceof CheckPoint)) break;
            this.lastKnownGoodPosition = this.marker.currentPosition();
        }
        assert (entry instanceof LogEntryStart) : "Expected Start entry, read " + entry + " instead";
        LogEntryStart startEntry = (LogEntryStart)entry.as();
        List<StorageCommand> entries = this.commandList();
        while (true) {
            if (!this.logEntryCursor.next()) {
                return false;
            }
            entry = this.logEntryCursor.get();
            if (entry instanceof LogEntryCommit) break;
            LogEntryCommand command = (LogEntryCommand)entry.as();
            entries.add(command.getXaCommand());
        }
        LogEntryCommit commitEntry = (LogEntryCommit)entry.as();
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(entries);
        transaction.setHeader(startEntry.getAdditionalHeader(), startEntry.getMasterId(), startEntry.getLocalId(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1);
        this.current = new CommittedTransactionRepresentation(startEntry, transaction, commitEntry);
        this.lastKnownGoodPosition = this.marker.currentPosition();
        return true;
    }

    public void close() throws IOException {
        this.logEntryCursor.close();
    }

    public long lastKnownGoodPosition() {
        return this.lastKnownGoodPosition;
    }

    private static class Marker<T extends PositionAwareChannel> {
        private final LogPositionMarker marker = new LogPositionMarker();
        private final T channel;

        public Marker(T channel) {
            this.channel = channel;
        }

        public long currentPosition() throws IOException {
            return this.channel.getCurrentPosition(this.marker).getByteOffset();
        }
    }
}

