/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.ToIntFunction;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.util.ReusableIteratorCostume;
import org.neo4j.unsafe.batchinsert.DirectRecordAccessSet;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class BatchInsertRelationshipsStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final RelationshipStore relationshipStore;
    private final ToIntFunction<Object> typeToId;
    private final RelationshipCreator relationshipCreator;
    private final Locks.Client noopLockClient = new NoOpClient();
    private final PropertyCreator propertyCreator;
    private final DirectRecordAccessSet recordAccess;
    private final PropertyStore propertyStore;
    private int pendingRelationshipChanges;
    private final ReusableIteratorCostume<PropertyBlock> blockIterator = new ReusableIteratorCostume();
    private final IdSequence relationshipIdGenerator;

    public BatchInsertRelationshipsStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, NeoStores store, ToIntFunction<Object> typeToId, long nextRelationshipId) {
        super(control, "INSERT", (Configuration)config, 1, new StatsProvider[0]);
        this.typeToId = typeToId;
        this.relationshipStore = store.getRelationshipStore();
        RelationshipGroupGetter groupGetter = new RelationshipGroupGetter(store.getRelationshipGroupStore());
        this.relationshipCreator = new RelationshipCreator(groupGetter, config.denseNodeThreshold());
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(store.getPropertyStore(), propertyTraverser);
        this.recordAccess = new DirectRecordAccessSet(store);
        this.propertyStore = store.getPropertyStore();
        this.relationshipIdGenerator = new BatchingIdSequence(nextRelationshipId);
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        int propertyBlockCursor = 0;
        for (int i = 0; i < ((InputRelationship[])batch.input).length; ++i) {
            InputRelationship input = ((InputRelationship[])batch.input)[i];
            int propertyBlockCount = batch.propertyBlocksLengths[i];
            long startNodeId = batch.ids[i * 2];
            long endNodeId = batch.ids[i * 2 + 1];
            if (startNodeId != -1L && endNodeId != -1L) {
                long id = this.relationshipIdGenerator.nextId();
                int typeId = this.typeToId.applyAsInt(input.typeAsObject());
                this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordAccess, this.noopLockClient);
                RelationshipRecord record = this.recordAccess.getRelRecords().getOrLoad(id, null).forChangingData();
                if (input.hasFirstPropertyId()) {
                    record.setNextProp(input.firstPropertyId());
                } else if (propertyBlockCount > 0) {
                    EntityStoreUpdaterStep.reassignDynamicRecordIds(this.propertyStore, batch.propertyBlocks, propertyBlockCursor, propertyBlockCount);
                    long firstProp = this.propertyCreator.createPropertyChain(record, this.blockIterator.dressArray((PropertyBlock[])batch.propertyBlocks, propertyBlockCursor, propertyBlockCount), this.recordAccess.getPropertyRecords());
                    record.setNextProp(firstProp);
                }
            }
            propertyBlockCursor += propertyBlockCount;
        }
        this.pendingRelationshipChanges += ((InputRelationship[])batch.input).length;
        if (this.pendingRelationshipChanges >= 50000) {
            this.recordAccess.close();
            this.pendingRelationshipChanges = 0;
        }
    }

    @Override
    protected void done() {
        this.recordAccess.close();
        super.done();
    }
}

