/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.executor;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.executor.ParkStrategy;
import org.neo4j.unsafe.impl.batchimport.executor.Task;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutor;

public class DynamicTaskExecutor<LOCAL>
implements TaskExecutor<LOCAL> {
    public static final ParkStrategy DEFAULT_PARK_STRATEGY = new ParkStrategy.Park(10);
    private final BlockingQueue<Task<LOCAL>> queue;
    private final ParkStrategy parkStrategy;
    private final String processorThreadNamePrefix;
    private volatile Processor[] processors = (Processor[])Array.newInstance(Processor.class, 0);
    private volatile boolean shutDown;
    private volatile Throwable panic;
    private final Supplier<LOCAL> initialLocalState;
    private final int maxProcessorCount;
    private static final Thread.UncaughtExceptionHandler SILENT_UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    };

    public DynamicTaskExecutor(int initialProcessorCount, int maxProcessorCount, int maxQueueSize, ParkStrategy parkStrategy, String processorThreadNamePrefix) {
        this(initialProcessorCount, maxProcessorCount, maxQueueSize, parkStrategy, processorThreadNamePrefix, Suppliers.singleton(null));
    }

    public DynamicTaskExecutor(int initialProcessorCount, int maxProcessorCount, int maxQueueSize, ParkStrategy parkStrategy, String processorThreadNamePrefix, Supplier<LOCAL> initialLocalState) {
        int n = this.maxProcessorCount = maxProcessorCount == 0 ? Integer.MAX_VALUE : maxProcessorCount;
        assert (this.maxProcessorCount >= initialProcessorCount) : "Unexpected initial processor count " + initialProcessorCount + " for max " + maxProcessorCount;
        this.parkStrategy = parkStrategy;
        this.processorThreadNamePrefix = processorThreadNamePrefix;
        this.initialLocalState = initialLocalState;
        this.queue = new ArrayBlockingQueue<Task<LOCAL>>(maxQueueSize);
        this.setNumberOfProcessors(initialProcessorCount);
    }

    @Override
    public synchronized void setNumberOfProcessors(int count) {
        Processor[] newProcessors;
        this.assertHealthy();
        assert (count > 0);
        if (count == this.processors.length) {
            return;
        }
        if ((count = Math.min(count, this.maxProcessorCount)) > this.processors.length) {
            newProcessors = Arrays.copyOf(this.processors, count);
            for (int i = this.processors.length; i < newProcessors.length; ++i) {
                newProcessors[i] = new Processor(this.processorThreadNamePrefix + "-" + i);
            }
        } else {
            newProcessors = Arrays.copyOf(this.processors, count);
            for (int i = newProcessors.length; i < this.processors.length; ++i) {
                this.processors[i].shutDown = true;
            }
        }
        this.processors = newProcessors;
    }

    @Override
    public int numberOfProcessors() {
        return this.processors.length;
    }

    @Override
    public synchronized boolean incrementNumberOfProcessors() {
        if (this.numberOfProcessors() >= this.maxProcessorCount) {
            return false;
        }
        this.setNumberOfProcessors(this.numberOfProcessors() + 1);
        return true;
    }

    @Override
    public synchronized boolean decrementNumberOfProcessors() {
        if (this.numberOfProcessors() == 1) {
            return false;
        }
        this.setNumberOfProcessors(this.numberOfProcessors() - 1);
        return true;
    }

    @Override
    public void submit(Task<LOCAL> task) {
        this.assertHealthy();
        while (!this.queue.offer(task)) {
            this.parkAWhile();
            this.assertHealthy();
        }
        this.notifyProcessors();
    }

    @Override
    public void assertHealthy() {
        if (this.shutDown) {
            String message = "Executor has been shut down";
            throw this.panic != null ? new IllegalStateException(message, this.panic) : new IllegalStateException(message);
        }
    }

    private void notifyProcessors() {
        for (Processor processor : this.processors) {
            this.parkStrategy.unpark(processor);
        }
    }

    @Override
    public synchronized void shutdown(boolean awaitAllCompleted) {
        if (this.shutDown) {
            return;
        }
        this.shutDown = true;
        while (awaitAllCompleted && !this.queue.isEmpty() && this.panic == null) {
            this.parkAWhile();
        }
        for (Processor processor : this.processors) {
            processor.shutDown = true;
        }
        while (awaitAllCompleted && this.anyAlive() && this.panic == null) {
            this.parkAWhile();
        }
    }

    private boolean anyAlive() {
        for (Processor processor : this.processors) {
            if (!processor.isAlive()) continue;
            return true;
        }
        return false;
    }

    private void parkAWhile() {
        this.parkStrategy.park(Thread.currentThread());
    }

    private class Processor
    extends Thread {
        private volatile boolean shutDown;
        private final LOCAL threadLocalState;

        Processor(String name) {
            super(name);
            this.threadLocalState = DynamicTaskExecutor.this.initialLocalState.get();
            this.setUncaughtExceptionHandler(SILENT_UNCAUGHT_EXCEPTION_HANDLER);
            this.start();
        }

        @Override
        public void run() {
            while (!this.shutDown) {
                Task task = (Task)DynamicTaskExecutor.this.queue.poll();
                if (task != null) {
                    try {
                        task.run(this.threadLocalState);
                        continue;
                    }
                    catch (Throwable e) {
                        DynamicTaskExecutor.this.panic = e;
                        DynamicTaskExecutor.this.shutdown(false);
                        throw Exceptions.launderedException(e);
                    }
                }
                DynamicTaskExecutor.this.parkAWhile();
            }
        }
    }
}

