/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChannel;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

abstract class InputEntityCacher<ENTITY extends InputEntity>
implements Receiver<ENTITY[], IOException> {
    protected final FlushableChannel channel;
    private final FlushableChannel header;
    private final StoreChannel storeChannel;
    private final StoreChannel headerChannel;
    private final int[] previousGroupIds;
    private final int[] nextKeyId = new int[4];
    private final int[] maxKeyId = new int[4];
    private final Map<String, Integer>[] tokens = new Map[4];

    protected InputEntityCacher(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int bufferSize, int groupSlots) throws IOException {
        int i;
        this.storeChannel = channel;
        this.headerChannel = header;
        this.previousGroupIds = new int[groupSlots];
        this.initMaxTokenKeyIds(recordFormats);
        for (i = 0; i < groupSlots; ++i) {
            this.previousGroupIds[i] = Group.GLOBAL.id();
        }
        this.channel = new PositionAwarePhysicalFlushableChannel(new PhysicalLogVersionedStoreChannel(channel, 0L, 0), bufferSize);
        this.header = new PositionAwarePhysicalFlushableChannel(new PhysicalLogVersionedStoreChannel(header, 0L, 0), (int)ByteUnit.kibiBytes((long)8L));
        for (i = 0; i < this.tokens.length; ++i) {
            this.tokens[i] = new HashMap<String, Integer>();
        }
    }

    @Override
    public void receive(ENTITY[] batch) throws IOException {
        for (ENTITY entity : batch) {
            this.writeEntity(entity);
        }
    }

    protected void writeEntity(ENTITY entity) throws IOException {
        if (((InputEntity)entity).hasFirstPropertyId()) {
            this.channel.putShort((short)-1).putLong(((InputEntity)entity).firstPropertyId());
        } else {
            Object[] properties = ((InputEntity)entity).properties();
            this.channel.putShort(Utils.safeCastLongToShort(properties.length / 2));
            for (int i = 0; i < properties.length; ++i) {
                Object key = properties[i++];
                Object value = properties[i];
                if (value == null) continue;
                this.writeToken((byte)0, key);
                this.writeValue(value);
            }
        }
    }

    protected void writeGroup(Group group, int slot) throws IOException {
        if (group.id() == this.previousGroupIds[slot]) {
            this.channel.put((byte)0);
        } else {
            this.channel.put((byte)1);
            this.previousGroupIds[slot] = group.id();
            this.channel.putInt(this.previousGroupIds[slot]);
            this.writeToken((byte)3, group.name());
        }
    }

    protected void writeValue(Object value) throws IOException {
        ValueType type = ValueType.typeOf(value);
        this.channel.put(type.id());
        type.write(value, this.channel);
    }

    protected void writeToken(byte type, Object key) throws IOException {
        if (key instanceof String) {
            Integer id = this.tokens[type].get(key);
            if (id == null) {
                if (this.nextKeyId[type] == this.maxKeyId[type]) {
                    throw new UnsupportedOperationException("Too many tokens. Creation of more then " + this.maxKeyId[type] + " tokens is not supported.");
                }
                byte by = type;
                int n = this.nextKeyId[by];
                this.nextKeyId[by] = n + 1;
                id = n;
                this.tokens[type].put((String)key, id);
                this.header.put(type);
                ValueType.stringType().write(key, this.header);
            }
            this.channel.putInt(id);
        } else if (key instanceof Integer) {
            this.channel.putInt(-1);
            this.channel.putInt((Integer)key);
        } else {
            throw new IllegalArgumentException("Invalid key " + key + ", " + key.getClass());
        }
    }

    @Override
    public void close() throws IOException {
        this.header.put((byte)-2);
        this.channel.putShort((short)-3);
        this.channel.close();
        this.header.close();
        this.storeChannel.close();
        this.headerChannel.close();
    }

    private void initMaxTokenKeyIds(RecordFormats recordFormats) {
        this.maxKeyId[0] = this.getMaxAcceptableTokenId(recordFormats.propertyKeyToken().getMaxId());
        this.maxKeyId[1] = this.getMaxAcceptableTokenId(recordFormats.labelToken().getMaxId());
        this.maxKeyId[2] = this.getMaxAcceptableTokenId(recordFormats.relationshipTypeToken().getMaxId());
        this.maxKeyId[3] = this.getMaxAcceptableTokenId(recordFormats.relationshipGroup().getMaxId());
    }

    private int getMaxAcceptableTokenId(long maxId) {
        return (int)Math.min(Integer.MAX_VALUE, maxId);
    }
}

