/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.function.Function;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputEntityDecorators {
    public static final Function<InputNode, InputNode> NO_NODE_DECORATOR = value -> value;
    public static final Function<InputRelationship, InputRelationship> NO_RELATIONSHIP_DECORATOR = value -> value;

    public static Function<InputNode, InputNode> additiveLabels(String[] labelNamesToAdd) {
        if (labelNamesToAdd == null || labelNamesToAdd.length == 0) {
            return value -> value;
        }
        return node -> {
            if (node.hasLabelField()) {
                return node;
            }
            String[] union = ArrayUtil.union(node.labels(), labelNamesToAdd);
            if (union != node.labels()) {
                node.setLabels(union);
            }
            return node;
        };
    }

    public static Function<InputRelationship, InputRelationship> defaultRelationshipType(String defaultType) {
        if (defaultType == null) {
            return value -> value;
        }
        return relationship -> {
            if (relationship.type() == null && !relationship.hasTypeId()) {
                relationship.setType(defaultType);
            }
            return relationship;
        };
    }

    public static <ENTITY extends InputEntity> Function<ENTITY, ENTITY> decorators(Function<ENTITY, ENTITY> ... decorators) {
        return from -> {
            for (Function decorator : decorators) {
                from = (InputEntity)decorator.apply(from);
            }
            return from;
        };
    }
}

