/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRecordsStep<RECORD extends AbstractBaseRecord>
extends IoProducerStep {
    protected final RecordStore<RECORD> store;
    protected final RECORD record;
    protected final RecordCursor<RECORD> cursor;
    protected final long highId;
    private final PrimitiveLongIterator ids;
    private final Class<RECORD> klass;
    private final int recordSize;
    private final Predicate<RECORD> filter;
    private long count;

    public ReadRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, PrimitiveLongIterator ids) {
        this(control, config, store, ids, (RECORD all) -> true);
    }

    public ReadRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, PrimitiveLongIterator ids, Predicate<RECORD> filter) {
        super(control, config);
        this.store = store;
        this.ids = ids;
        this.filter = filter;
        this.klass = store.newRecord().getClass();
        this.recordSize = store.getRecordSize();
        this.record = store.newRecord();
        this.cursor = store.newRecordCursor(this.record);
        this.highId = store.getHighId();
    }

    @Override
    public void start(int orderingGuarantees) {
        this.cursor.acquire(0L, RecordLoad.CHECK);
        super.start(orderingGuarantees);
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        if (!this.ids.hasNext()) {
            return null;
        }
        AbstractBaseRecord[] batch = (AbstractBaseRecord[])Array.newInstance(this.klass, batchSize);
        boolean seenReservedId = false;
        int i = 0;
        while (i < batchSize && this.ids.hasNext()) {
            AbstractBaseRecord newRecord;
            this.cursor.next(this.ids.next());
            if (!this.filter.test(this.record)) continue;
            batch[i] = newRecord = ((AbstractBaseRecord)this.record).clone();
            seenReservedId |= IdValidator.isReservedId(newRecord.getId());
            ++i;
            ++this.count;
        }
        batch = i == batchSize ? batch : Arrays.copyOf(batch, i);
        batch = this.removeRecordWithReservedId(batch, seenReservedId);
        return batch.length > 0 ? batch : null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.cursor.close();
    }

    @Override
    protected long position() {
        return this.count * (long)this.recordSize;
    }

    protected RECORD[] removeRecordWithReservedId(RECORD[] records, boolean seenReservedId) {
        if (!seenReservedId) {
            return records;
        }
        return (AbstractBaseRecord[])Stream.of(records).filter(record -> !IdValidator.isReservedId(record.getId())).toArray(length -> this.newArray(length, records.getClass().getComponentType()));
    }

    private RECORD[] newArray(int length, Class<?> componentType) {
        return (AbstractBaseRecord[])Array.newInstance(componentType, length);
    }
}

