/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class RelationshipTypeCheckerStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private static final Function<Object, MutableLong> NEW_MUTABLE_LONG = type -> new MutableLong();
    private static final Comparator<Map.Entry<Object, MutableLong>> SORT_BY_COUNT_DESC = (e1, e2) -> Long.compare(((MutableLong)e2.getValue()).longValue(), ((MutableLong)e1.getValue()).longValue());
    private static final Comparator<Map.Entry<Object, MutableLong>> SORT_BY_ID_DESC = (e1, e2) -> Integer.compare((Integer)e2.getKey(), (Integer)e1.getKey());
    private final Map<Thread, Map<Object, MutableLong>> typeCheckers = new ConcurrentHashMap<Thread, Map<Object, MutableLong>>();
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository typeTokenRepository;
    private Map.Entry<Object, MutableLong>[] sortedTypes;

    public RelationshipTypeCheckerStep(StageControl control, Configuration config, BatchingTokenRepository.BatchingRelationshipTypeTokenRepository typeTokenRepository) {
        super(control, "TYPE", config, 0, new StatsProvider[0]);
        this.typeTokenRepository = typeTokenRepository;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) throws Throwable {
        Map typeMap = this.typeCheckers.computeIfAbsent(Thread.currentThread(), t -> new HashMap());
        Stream.of(batch.input).map(InputRelationship::typeAsObject).forEach(type -> typeMap.computeIfAbsent(type, NEW_MUTABLE_LONG).increment());
        sender.send(batch);
    }

    @Override
    protected void done() {
        HashMap mergedTypes = new HashMap();
        this.typeCheckers.forEach((thread, localTypes) -> localTypes.forEach((type, localCount) -> mergedTypes.computeIfAbsent(type, t -> new MutableLong()).add(localCount.longValue())));
        this.sortedTypes = mergedTypes.entrySet().toArray(new Map.Entry[mergedTypes.size()]);
        if (this.sortedTypes.length > 0) {
            Comparator<Map.Entry<Object, MutableLong>> comparator = this.sortedTypes[0].getKey() instanceof Integer ? SORT_BY_ID_DESC : SORT_BY_COUNT_DESC;
            Arrays.sort(this.sortedTypes, comparator);
        }
        for (int i = this.sortedTypes.length - 1; i >= 0; --i) {
            this.typeTokenRepository.getOrCreateId(this.sortedTypes[i].getKey());
        }
        super.done();
    }

    public Object[] getRelationshipTypes(long belowOrEqualToThreshold) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, MutableLong> candidate : this.sortedTypes) {
            if (candidate.getValue().longValue() > belowOrEqualToThreshold) continue;
            result.add(candidate.getKey());
        }
        return result.toArray();
    }
}

