/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public interface NumberArrayFactory {
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            return new HeapIntArray(Utils.safeCastLongToInt(length), defaultValue, Math.toIntExact(base));
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            return new HeapLongArray(Utils.safeCastLongToInt(length), defaultValue, Math.toIntExact(base));
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            return new HeapByteArray(Utils.safeCastLongToInt(length), defaultValue, Math.toIntExact(base));
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            return new OffHeapIntArray(length, defaultValue, base);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            return new OffHeapLongArray(length, defaultValue, base);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            return new OffHeapByteArray(length, defaultValue, base);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new Adapter(){
        private final NumberArrayFactory delegate = new Auto(OFF_HEAP, HEAP);

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            LongArray array = this.newDynamicLongArray(this.fractionOf(length), defaultValue);
            array.at(length - 1L);
            return array;
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            IntArray array = this.newDynamicIntArray(this.fractionOf(length), defaultValue);
            array.at(length - 1L);
            return array;
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            ByteArray array = this.newDynamicByteArray(this.fractionOf(length), defaultValue);
            array.at(length - 1L);
            return array;
        }

        private long fractionOf(long length) {
            return length / 10L;
        }

        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray(this.delegate, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray(this.delegate, chunkSize, defaultValue);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
            return new DynamicByteArray(this.delegate, chunkSize, defaultValue);
        }

        public String toString() {
            return "CHUNKED_FIXED_SIZE";
        }
    };
    public static final NumberArrayFactory AUTO = new Auto(OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    default public IntArray newIntArray(long length, int defaultValue) {
        return this.newIntArray(length, defaultValue, 0L);
    }

    public IntArray newIntArray(long var1, int var3, long var4);

    public IntArray newDynamicIntArray(long var1, int var3);

    default public LongArray newLongArray(long length, long defaultValue) {
        return this.newLongArray(length, defaultValue, 0L);
    }

    public LongArray newLongArray(long var1, long var3, long var5);

    public LongArray newDynamicLongArray(long var1, long var3);

    default public ByteArray newByteArray(long length, byte[] defaultValue) {
        return this.newByteArray(length, defaultValue, 0L);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4);

    public ByteArray newDynamicByteArray(long var1, byte[] var3);

    public static class Auto
    extends Adapter {
        private final NumberArrayFactory[] candidates;

        public Auto(NumberArrayFactory ... candidates) {
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    return candidate.newLongArray(length, defaultValue, base);
                }
                catch (OutOfMemoryError e) {
                    error = e;
                }
            }
            throw this.error(length, 8, error);
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    return candidate.newIntArray(length, defaultValue, base);
                }
                catch (OutOfMemoryError e) {
                    error = e;
                }
            }
            throw this.error(length, 4, error);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    return candidate.newByteArray(length, defaultValue, base);
                }
                catch (OutOfMemoryError e) {
                    error = e;
                }
            }
            throw this.error(length, defaultValue.length, error);
        }

        private OutOfMemoryError error(long length, int itemSize, OutOfMemoryError error) {
            throw Exceptions.withMessage(error, String.format("%s: Not enough memory available for allocating %s, tried %s", error.getMessage(), Format.bytes(length * (long)itemSize), Arrays.toString(this.candidates)));
        }
    }

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
            return new DynamicByteArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }
    }
}

