/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Map;
import org.neo4j.kernel.impl.query.QuerySource;

public class ExecutingQuery {
    private final long queryId;
    private final String username;
    private final QuerySource querySource;
    private final String queryText;
    private final Map<String, Object> queryParameters;
    private final long startTime;
    private Map<String, Object> metaData;

    public ExecutingQuery(long queryId, QuerySource querySource, String username, String queryText, Map<String, Object> queryParameters, long startTime, Map<String, Object> metaData) {
        this.queryId = queryId;
        this.querySource = querySource;
        this.username = username;
        this.queryText = queryText;
        this.queryParameters = queryParameters;
        this.startTime = startTime;
        this.metaData = metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String username() {
        return this.username;
    }

    public QuerySource querySource() {
        return this.querySource;
    }

    public String queryText() {
        return this.queryText;
    }

    public Map<String, Object> queryParameters() {
        return this.queryParameters;
    }

    public long startTime() {
        return this.startTime;
    }

    public String toString() {
        return String.format("ExecutingQuery{queryId=%d, querySource='%s', username='%s', queryText='%s', queryParameters=%s, startTime=%d}", this.queryId, this.querySource.toString(":"), this.username, this.queryText, this.queryParameters, this.startTime);
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }
}

