/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.storageengine.api.EntityType;

public class DuplicateEntitySchemaRuleException
extends DuplicateSchemaRuleException {
    private static final String DUPLICATE_NODE_RULE_MESSAGE_TEMPLATE = "Multiple %s found for label '%s' and property '%s'.";
    private static final String DUPLICATED_RELATIONSHIP_RULE_MESSAGE_TEMPLATE = "Multiple %s found for relationship type '%s' and property '%s'.";
    private final EntityType entityType;

    public DuplicateEntitySchemaRuleException(EntityType entityType, int entityId, int propertyKeyId) {
        this(entityType, entityId, propertyKeyId, false);
    }

    public DuplicateEntitySchemaRuleException(EntityType entityType, int ruleEntityId, int propertyKeyId, boolean unique) {
        super(DuplicateEntitySchemaRuleException.getMessageTemplate(entityType), ruleEntityId, propertyKeyId, unique ? "uniqueness constraints" : "constraints");
        this.entityType = entityType;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String entityName = EntityType.NODE == this.entityType ? tokenNameLookup.labelGetName(this.ruleEntityId) : tokenNameLookup.relationshipTypeGetName(this.ruleEntityId);
        return String.format(this.messageTemplate, this.messagePrefix, entityName, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    private static String getMessageTemplate(EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return DUPLICATE_NODE_RULE_MESSAGE_TEMPLATE;
            }
            case RELATIONSHIP: {
                return DUPLICATED_RELATIONSHIP_RULE_MESSAGE_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Schema rules for specified entityType not supported.");
    }
}

