/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.Neo4jValue;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.procedure.Name;

public class MethodSignatureCompiler {
    private final TypeMappers typeMappers;

    public MethodSignatureCompiler(TypeMappers typeMappers) {
        this.typeMappers = typeMappers;
    }

    public List<Neo4jTypes.AnyType> inputTypesFor(Method method) throws ProcedureException {
        Type[] types = method.getGenericParameterTypes();
        ArrayList<Neo4jTypes.AnyType> neoTypes = new ArrayList<Neo4jTypes.AnyType>(types.length);
        for (Type type : types) {
            TypeMappers.NeoValueConverter valueConverter = this.typeMappers.converterFor(type);
            neoTypes.add(valueConverter.type());
        }
        return neoTypes;
    }

    public List<FieldSignature> signatureFor(Method method) throws ProcedureException {
        Parameter[] params = method.getParameters();
        Type[] types = method.getGenericParameterTypes();
        ArrayList<FieldSignature> signature = new ArrayList<FieldSignature>(params.length);
        boolean seenDefault = false;
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            Type type = types[i];
            if (!param.isAnnotationPresent(Name.class)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is missing an `@%s` annotation.%nPlease add the annotation, recompile the class and try again.", i, method.getName(), Name.class.getSimpleName());
            }
            Name parameter = param.getAnnotation(Name.class);
            String name = parameter.value();
            if (name.trim().length() == 0) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Argument at position %d in method `%s` is annotated with a name,%nbut the name is empty, please provide a non-empty name for the argument.", i, method.getName());
            }
            try {
                TypeMappers.NeoValueConverter valueConverter = this.typeMappers.converterFor(type);
                Optional<Neo4jValue> defaultValue = valueConverter.defaultValue(parameter);
                if (seenDefault && !defaultValue.isPresent()) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Non-default argument at position %d with name %s in method %s follows default argument. Add a default value or rearrange arguments so that the non-default values comes first.", i, parameter.value(), method.getName());
                }
                seenDefault = defaultValue.isPresent();
                signature.add(new FieldSignature(name, valueConverter.type(), defaultValue));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), "Argument `%s` at position %d in `%s` with%ntype `%s` cannot be converted to a Neo4j type: %s", name, i, method.getName(), param.getType().getSimpleName(), e.getMessage());
            }
        }
        return signature;
    }
}

