/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;

enum MigrationStatus {
    migrating,
    moving,
    countsRebuilding,
    completed;


    public boolean isNeededFor(MigrationStatus current) {
        return current == null || this.ordinal() >= current.ordinal();
    }

    public String maybeReadInfo(FileSystemAbstraction fs, File stateFile, String currentInfo) {
        if (currentInfo != null) {
            return currentInfo;
        }
        Pair<String, String> data = MigrationStatus.readFromFile(fs, stateFile, this);
        return data == null ? null : (String)data.other();
    }

    public static MigrationStatus readMigrationStatus(FileSystemAbstraction fs, File stateFile) {
        Pair<String, String> data = MigrationStatus.readFromFile(fs, stateFile, null);
        if (data == null) {
            return null;
        }
        return MigrationStatus.valueOf((String)data.first());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, String> readFromFile(FileSystemAbstraction fs, File file, MigrationStatus expectedSate) {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, StandardCharsets.UTF_8));){
            String state = reader.readLine().trim();
            if (expectedSate != null && !expectedSate.name().equals(state)) {
                throw new IllegalStateException("Not in the expected state, expected=" + expectedSate.name() + ", actual=" + state);
            }
            String info = reader.readLine().trim();
            Pair pair = Pair.of((Object)state, (Object)info);
            return pair;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMigrationStatus(FileSystemAbstraction fs, File stateFile, String info) {
        if (fs.fileExists(stateFile)) {
            try {
                fs.truncate(stateFile, 0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (Writer writer = fs.openAsWriter(stateFile, StandardCharsets.UTF_8, false);){
            writer.write(this.name());
            writer.write(10);
            writer.write(info);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

