/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

class LogEntrySanity {
    private static final long UNREASONABLY_LONG_TIME = TimeUnit.DAYS.toMillis(10950L);
    private static final int UNREASONABLY_HIGH_SERVER_ID = 10000000;

    LogEntrySanity() {
    }

    static boolean logEntryMakesSense(LogEntry entry) {
        if (entry == null) {
            return false;
        }
        if (entry instanceof IdentifiableLogEntry) {
            IdentifiableLogEntry iEntry = (IdentifiableLogEntry)entry;
            entry = iEntry.getEntry();
        }
        if (entry instanceof LogEntryStart) {
            return LogEntrySanity.startEntryMakesSense((LogEntryStart)entry);
        }
        if (entry instanceof LogEntryCommit) {
            return LogEntrySanity.commitEntryMakesSense((LogEntryCommit)entry);
        }
        return true;
    }

    static boolean commitEntryMakesSense(LogEntryCommit entry) {
        return LogEntrySanity.timeMakesSense(entry.getTimeWritten()) && LogEntrySanity.transactionIdMakesSense(entry);
    }

    private static boolean transactionIdMakesSense(LogEntryCommit entry) {
        return entry.getTxId() > 1L;
    }

    static boolean startEntryMakesSense(LogEntryStart entry) {
        return LogEntrySanity.serverIdMakesSense(entry.getLocalId()) && LogEntrySanity.serverIdMakesSense(entry.getMasterId()) && LogEntrySanity.timeMakesSense(entry.getTimeWritten());
    }

    private static boolean serverIdMakesSense(int serverId) {
        return serverId >= 0 && serverId < 10000000;
    }

    static boolean timeMakesSense(long time) {
        return Math.abs(System.currentTimeMillis() - time) < UNREASONABLY_LONG_TIME;
    }
}

