/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.storageengine.api.Token;

public class TokenCreator<R extends TokenRecord, T extends Token> {
    private final TokenStore<R, T> store;

    public TokenCreator(TokenStore<R, T> store) {
        this.store = store;
    }

    public void createToken(String name, int id, RecordAccess<Integer, R, Void> recordAccess) {
        TokenRecord record = (TokenRecord)recordAccess.create(id, null).forChangingData();
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = this.store.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
    }
}

