/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RecordChanges;
import org.neo4j.kernel.impl.transaction.state.RecordState;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.kernel.impl.util.statistics.IntCounter;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class TransactionRecordState
implements RecordState {
    private static final Command[] EMPTY_COMMANDS = new Command[0];
    private final NeoStores neoStores;
    private final IntegrityValidator integrityValidator;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final MetaDataStore metaDataStore;
    private final SchemaStore schemaStore;
    private final RecordAccessSet recordChangeSet;
    private final long lastCommittedTxWhenTransactionStarted;
    private final ResourceLocker locks;
    private final RelationshipCreator relationshipCreator;
    private final RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private RecordChanges<Long, NeoStoreRecord, Void> neoStoreRecord;
    private boolean prepared;
    private static final CommandSorter COMMAND_SORTER = new CommandSorter();

    public TransactionRecordState(NeoStores neoStores, IntegrityValidator integrityValidator, RecordChangeSet recordChangeSet, long lastCommittedTxWhenTransactionStarted, ResourceLocker locks, RelationshipCreator relationshipCreator, RelationshipDeleter relationshipDeleter, PropertyCreator propertyCreator, PropertyDeleter propertyDeleter) {
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.metaDataStore = neoStores.getMetaDataStore();
        this.schemaStore = neoStores.getSchemaStore();
        this.integrityValidator = integrityValidator;
        this.recordChangeSet = recordChangeSet;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.locks = locks;
        this.relationshipCreator = relationshipCreator;
        this.relationshipDeleter = relationshipDeleter;
        this.propertyCreator = propertyCreator;
        this.propertyDeleter = propertyDeleter;
    }

    @Override
    public boolean hasChanges() {
        return this.recordChangeSet.hasChanges() || this.neoStoreRecord != null && this.neoStoreRecord.changeSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void extractCommands(Collection<StorageCommand> commands) throws TransactionFailureException {
        void var7_23;
        void var4_10;
        assert (!this.prepared) : "Transaction has already been prepared";
        this.integrityValidator.validateTransactionStartKnowledge(this.lastCommittedTxWhenTransactionStarted);
        int noOfCommands = this.recordChangeSet.changeSize() + (this.neoStoreRecord != null ? this.neoStoreRecord.changeSize() : 0);
        for (RecordAccess.RecordProxy<Integer, LabelTokenRecord, Void> recordProxy : this.recordChangeSet.getLabelTokenChanges().changes()) {
            commands.add(new Command.LabelTokenCommand(recordProxy.getBefore(), recordProxy.forReadingLinkage()));
        }
        for (RecordAccess.RecordProxy<Integer, TokenRecord, Void> recordProxy : this.recordChangeSet.getRelationshipTypeTokenChanges().changes()) {
            commands.add(new Command.RelationshipTypeTokenCommand((RelationshipTypeTokenRecord)recordProxy.getBefore(), (RelationshipTypeTokenRecord)recordProxy.forReadingLinkage()));
        }
        for (RecordAccess.RecordProxy<Integer, TokenRecord, Void> recordProxy : this.recordChangeSet.getPropertyKeyTokenChanges().changes()) {
            commands.add(new Command.PropertyKeyTokenCommand((PropertyKeyTokenRecord)recordProxy.getBefore(), (PropertyKeyTokenRecord)recordProxy.forReadingLinkage()));
        }
        Command[] nodeCommands = EMPTY_COMMANDS;
        boolean bl = false;
        if (this.recordChangeSet.getNodeRecords().changeSize() > 0) {
            nodeCommands = new Command[this.recordChangeSet.getNodeRecords().changeSize()];
            int i = 0;
            for (RecordAccess.RecordProxy<Long, NodeRecord, Void> recordProxy : this.recordChangeSet.getNodeRecords().changes()) {
                NodeRecord nodeRecord = this.prepared(recordProxy, this.nodeStore);
                this.integrityValidator.validateNodeRecord(nodeRecord);
                nodeCommands[i++] = new Command.NodeCommand(recordProxy.getBefore(), nodeRecord);
            }
            Arrays.sort(nodeCommands, COMMAND_SORTER);
        }
        Command[] relCommands = EMPTY_COMMANDS;
        if (this.recordChangeSet.getRelRecords().changeSize() > 0) {
            relCommands = new Command[this.recordChangeSet.getRelRecords().changeSize()];
            int i = 0;
            for (RecordAccess.RecordProxy<Long, RelationshipRecord, Void> recordProxy : this.recordChangeSet.getRelRecords().changes()) {
                relCommands[i++] = new Command.RelationshipCommand(recordProxy.getBefore(), this.prepared(recordProxy, this.relationshipStore));
            }
            Arrays.sort(relCommands, COMMAND_SORTER);
        }
        Command[] propCommands = EMPTY_COMMANDS;
        if (this.recordChangeSet.getPropertyRecords().changeSize() > 0) {
            propCommands = new Command[this.recordChangeSet.getPropertyRecords().changeSize()];
            boolean bl2 = false;
            for (RecordAccess.RecordProxy<Long, PropertyRecord, PrimitiveRecord> recordProxy : this.recordChangeSet.getPropertyRecords().changes()) {
                propCommands[++var7_19] = new Command.PropertyCommand(recordProxy.getBefore(), this.prepared(recordProxy, this.propertyStore));
            }
            Arrays.sort(propCommands, COMMAND_SORTER);
        }
        Command[] commandArray = EMPTY_COMMANDS;
        if (this.recordChangeSet.getRelGroupRecords().changeSize() > 0) {
            void var8_30;
            Command[] commandArray2 = new Command[this.recordChangeSet.getRelGroupRecords().changeSize()];
            boolean bl3 = false;
            for (RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> recordProxy : this.recordChangeSet.getRelGroupRecords().changes()) {
                if (recordProxy.isCreated() && !recordProxy.forReadingLinkage().inUse()) {
                    ++var4_10;
                    continue;
                }
                commandArray2[++var8_30] = new Command.RelationshipGroupCommand(recordProxy.getBefore(), this.prepared(recordProxy, this.relationshipGroupStore));
            }
            Command[] commandArray3 = var8_30 < commandArray2.length ? Arrays.copyOf(commandArray2, (int)var8_30) : commandArray2;
            Arrays.sort(commandArray3, COMMAND_SORTER);
        }
        this.addFiltered(commands, Command.Mode.CREATE, new Command[][]{propCommands, relCommands, var7_23, nodeCommands});
        this.addFiltered(commands, Command.Mode.UPDATE, new Command[][]{propCommands, relCommands, var7_23, nodeCommands});
        this.addFiltered(commands, Command.Mode.DELETE, new Command[][]{propCommands, relCommands, var7_23, nodeCommands});
        if (this.neoStoreRecord != null) {
            for (RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> recordProxy : this.neoStoreRecord.changes()) {
                commands.add(new Command.NeoStoreCommand(recordProxy.getBefore(), recordProxy.forReadingData()));
            }
        }
        for (RecordAccess.RecordProxy<Long, SchemaRecord, SchemaRule> recordProxy : this.recordChangeSet.getSchemaRuleChanges().changes()) {
            this.integrityValidator.validateSchemaRule(recordProxy.getAdditionalData());
            commands.add(new Command.SchemaRuleCommand(recordProxy.getBefore(), recordProxy.forChangingData(), recordProxy.getAdditionalData()));
        }
        assert (commands.size() == noOfCommands - var4_10) : String.format("Expected %d final commands, got %d instead, with %d skipped", noOfCommands, commands.size(), (int)var4_10);
        this.prepared = true;
    }

    private <RECORD extends AbstractBaseRecord> RECORD prepared(RecordAccess.RecordProxy<?, RECORD, ?> proxy, RecordStore<RECORD> store) {
        AbstractBaseRecord after = (AbstractBaseRecord)proxy.forReadingLinkage();
        store.prepareForCommit(after);
        return (RECORD)after;
    }

    public void relCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordChangeSet, this.locks);
    }

    public void relDelete(long relId) {
        this.relationshipDeleter.relDelete(relId, this.recordChangeSet, this.locks);
    }

    @SafeVarargs
    private final void addFiltered(Collection<StorageCommand> target, Command.Mode mode, Command[] ... commands) {
        Command[][] commandArray = commands;
        int n = commandArray.length;
        for (int i = 0; i < n; ++i) {
            Command[] c;
            for (Command command : c = commandArray[i]) {
                if (command.getMode() != mode) continue;
                target.add(command);
            }
        }
    }

    public void nodeDelete(long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        if (!nodeRecord.inUse()) {
            throw new IllegalStateException("Unable to delete Node[" + nodeId + "] since it has already been deleted.");
        }
        nodeRecord.setInUse(false);
        nodeRecord.setLabelField(Record.NO_LABELS_FIELD.intValue(), this.markNotInUse(nodeRecord.getDynamicLabelRecords()));
        this.getAndDeletePropertyChain(nodeRecord);
    }

    private Collection<DynamicRecord> markNotInUse(Collection<DynamicRecord> dynamicLabelRecords) {
        for (DynamicRecord record : dynamicLabelRecords) {
            record.setInUse(false);
        }
        return dynamicLabelRecords;
    }

    private void getAndDeletePropertyChain(NodeRecord nodeRecord) {
        this.propertyDeleter.deletePropertyChain(nodeRecord, this.recordChangeSet.getPropertyRecords());
    }

    public void relRemoveProperty(long relId, int propertyKey) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyDeleter.removeProperty(rel, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    public void nodeRemoveProperty(long nodeId, int propertyKey) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyDeleter.removeProperty(node, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    public DefinedProperty relChangeProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeChangeProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public DefinedProperty relAddProperty(long relId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, RelationshipRecord, Object> rel = this.recordChangeSet.getRelRecords().getOrLoad(relId, null);
        this.propertyCreator.primitiveSetProperty(rel, propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public DefinedProperty nodeAddProperty(long nodeId, int propertyKey, Object value) {
        RecordAccess.RecordProxy<Long, NodeRecord, Object> node = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null);
        this.propertyCreator.primitiveSetProperty(node, propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public void nodeCreate(long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().create(nodeId, null).forChangingData();
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
    }

    public void createPropertyKeyToken(String key, int id) {
        TokenCreator<PropertyKeyTokenRecord, Token> creator = new TokenCreator<PropertyKeyTokenRecord, Token>(this.neoStores.getPropertyKeyTokenStore());
        creator.createToken(key, id, this.recordChangeSet.getPropertyKeyTokenChanges());
    }

    public void createLabelToken(String name, int id) {
        TokenCreator<LabelTokenRecord, Token> creator = new TokenCreator<LabelTokenRecord, Token>(this.neoStores.getLabelTokenStore());
        creator.createToken(name, id, this.recordChangeSet.getLabelTokenChanges());
    }

    public void createRelationshipTypeToken(String name, int id) {
        TokenCreator<RelationshipTypeTokenRecord, RelationshipTypeToken> creator = new TokenCreator<RelationshipTypeTokenRecord, RelationshipTypeToken>(this.neoStores.getRelationshipTypeTokenStore());
        creator.createToken(name, id, this.recordChangeSet.getRelationshipTypeTokenChanges());
    }

    private RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> getOrLoadNeoStoreRecord() {
        if (this.neoStoreRecord == null) {
            this.neoStoreRecord = new RecordChanges<Long, NeoStoreRecord, Void>(new RecordAccess.Loader<Long, NeoStoreRecord, Void>(){

                @Override
                public NeoStoreRecord newUnused(Long key, Void additionalData) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NeoStoreRecord load(Long key, Void additionalData) {
                    return TransactionRecordState.this.metaDataStore.graphPropertyRecord();
                }

                @Override
                public void ensureHeavy(NeoStoreRecord record) {
                }

                @Override
                public NeoStoreRecord clone(NeoStoreRecord neoStoreRecord) {
                    return neoStoreRecord.clone();
                }
            }, new IntCounter());
        }
        return this.neoStoreRecord.getOrLoad(0L, null);
    }

    public DefinedProperty graphAddProperty(int propertyKey, Object value) {
        this.propertyCreator.primitiveSetProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public DefinedProperty graphChangeProperty(int propertyKey, Object value) {
        this.propertyCreator.primitiveSetProperty(this.getOrLoadNeoStoreRecord(), propertyKey, value, this.recordChangeSet.getPropertyRecords());
        return Property.property(propertyKey, value);
    }

    public void graphRemoveProperty(int propertyKey) {
        RecordAccess.RecordProxy<Long, NeoStoreRecord, Void> recordChange = this.getOrLoadNeoStoreRecord();
        this.propertyDeleter.removeProperty(recordChange, propertyKey, this.recordChangeSet.getPropertyRecords());
    }

    public void createSchemaRule(SchemaRule schemaRule) {
        for (DynamicRecord change : this.recordChangeSet.getSchemaRuleChanges().create(schemaRule.getId(), schemaRule).forChangingData()) {
            change.setInUse(true);
            change.setCreated();
        }
    }

    public void dropSchemaRule(SchemaRule rule) {
        RecordAccess.RecordProxy<Long, SchemaRecord, SchemaRule> change = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(rule.getId(), rule);
        SchemaRecord records = change.forChangingData();
        for (DynamicRecord record : records) {
            record.setInUse(false);
        }
    }

    public void addLabelToNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).add(labelId, this.nodeStore, this.nodeStore.getDynamicLabelStore());
    }

    public void removeLabelFromNode(int labelId, long nodeId) {
        NodeRecord nodeRecord = this.recordChangeSet.getNodeRecords().getOrLoad(nodeId, null).forChangingData();
        NodeLabelsField.parseLabelsField(nodeRecord).remove(labelId, this.nodeStore);
    }

    public void setConstraintIndexOwner(IndexRule indexRule, long constraintId) {
        RecordAccess.RecordProxy<Long, SchemaRecord, SchemaRule> change = this.recordChangeSet.getSchemaRuleChanges().getOrLoad(indexRule.getId(), indexRule);
        SchemaRecord records = change.forChangingData();
        indexRule = indexRule.withOwningConstraint(constraintId);
        records.setDynamicRecords(this.schemaStore.allocateFrom(indexRule));
    }

    public static interface PropertyReceiver<P extends StorageProperty> {
        public void receive(P var1, long var2);
    }

    private static class CommandSorter
    implements Comparator<Command> {
        private CommandSorter() {
        }

        @Override
        public int compare(Command o1, Command o2) {
            long id2;
            long id1 = o1.getKey();
            long diff = id1 - (id2 = o2.getKey());
            if (diff > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                return Integer.MIN_VALUE;
            }
            return (int)diff;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof CommandSorter;
        }

        public int hashCode() {
            return 3217;
        }
    }
}

